package maslab.data;

import java.io.*;
import java.util.*;

import maslab.util.*;


public class DataLogWriter
{
    BufferedWriter outs;
    double timeOffset=0;

    int recordsWritten=0;

    /** Open a new log for writing.
     * @param path The path of the log file
     * @param timeOffset The amount to subtract from all time
     **/
    public DataLogWriter(String path, double timeOffset) throws IOException
    {
	this.timeOffset=timeOffset;

	outs=new BufferedWriter(new FileWriter(path));
    }

    public synchronized void write(DataEvent e) throws IOException
    {
	outs.write(StringUtil.formatDouble(e.getTimeStamp()-timeOffset,3)+"\t"+
		   e.getEventName()+"\t"+
		   e.getChannelName()+"\t"+
		   ":"+"\t"+
		   e.getDataString()+"\n");

	recordsWritten++;
    }
    
    public void close() throws IOException
    {
	outs.close();
    }

    public int getRecordsWritten()
    {
	return recordsWritten;
    }
}
