package maslab.fig;

import maslab.geom.*;
import java.util.*;
import java.io.*;

public class FigPolyLine extends FigObject
{
    public int subtype;
    public int linestyle;
    public int thickness;
    public int pencolor;
    public int fillcolor;
    public int depth;
    public int penstyle;
    public int areafill;
    public float styleval;
    public int joinstyle;
    public int capstyle;
    public int radius;
    public boolean hasforwardarrow;
    public boolean hasbackwardarrow;
    public int npoints;

    // used only for imported-picture bounding-boxes
    public boolean flipped;
    public String filename;

    public ArrayList<GPoint2D> points=new ArrayList<GPoint2D>();

    public FigArrow forwardarrow=null;
    public FigArrow backwardarrow=null;

    public boolean parse(Scanner scan)
    {
	boolean success=true;

	subtype=scan.nextInt();
	linestyle=scan.nextInt();
	thickness=scan.nextInt();
	pencolor=scan.nextInt();
	fillcolor=scan.nextInt();
	depth=scan.nextInt();
	penstyle=scan.nextInt();
	areafill=scan.nextInt();
	styleval=scan.nextFloat();
	joinstyle=scan.nextInt();
	capstyle=scan.nextInt();
	radius=scan.nextInt();
	hasforwardarrow=(scan.nextInt()==1);
	hasbackwardarrow=(scan.nextInt()==1);
	npoints=scan.nextInt();

	if (hasforwardarrow)
	    {
		forwardarrow=new FigArrow();
		success&=forwardarrow.parse(scan);
	    }
	if (hasbackwardarrow)
	    {
		backwardarrow=new FigArrow();
		success&=backwardarrow.parse(scan);
	    }

	if (subtype==5)
	    {
		flipped=(scan.nextInt()==1);
		filename=scan.next();
	    }

	for (int i=0;i<npoints;i++)
	    {
		int x=scan.nextInt();
		int y=scan.nextInt();

		points.add(new GPoint2D(x,y));
	    }

	return success;
    }

    public void print(PrintStream out)
    {
	out.println("PolyLine with "+npoints+" points");

    }
}
