package maslab.geom;

import Jama.*;
 
import java.io.*;

/** A 2D point **/
public class GPoint2D implements Cloneable, Serializable
{
    protected double x;
    protected double y;

    public final static GPoint2D ORIGIN=new GPoint2D(0,0);

    static final long serialVersionUID=1001;

    public GPoint2D()
    {
	x=0;
	y=0;
    }

    public double getX()
    {
	return x;
    }

    public double getY()
    {
	return y;
    }

    public GPoint2D(double x, double y)
    {
	this.x=x;
	this.y=y;
    }

    public double distanceTo(GPoint2D p)
    {
	return Math.sqrt((p.x-x)*(p.x-x) + (p.y-y)*(p.y-y));
    }

    /** Transform the point by rotating it, then translating it. **/
    public GPoint2D transform(double dx, double dy, double theta)
    {
	GPoint2D np=new GPoint2D();

	np.x=x*Math.cos(theta)-y*Math.sin(theta)+dx;
	np.y=x*Math.sin(theta)+y*Math.cos(theta)+dy;

	return np;
    }

    /** Transform the point by premultiplying by the provided 3x3 matrix. **/
    public GPoint2D transform(Matrix P)
    {
	if (P.getColumnDimension()==1)
	    {
		/*	StackTraceElement[] trace=Thread.currentThread().getStackTrace();
		String m=trace[5].getMethodName();
		if (!m.equals("eval"))
		    System.out.println(trace[5].getClassName()+"."+trace[5].getMethodName());
		*/
		return transform(P.get(0,0),P.get(1,0),P.get(2,0));
	    }
	
	GPoint2D np=new GPoint2D();
	np.x=x*P.get(0,0)+y*P.get(0,1)+P.get(0,2);
	np.y=x*P.get(1,0)+y*P.get(1,1)+P.get(1,2);

	return np;
    }

    public GPoint2D scale(double s)
    {
	return new GPoint2D(x*s, y*s);
    }

    public String toString()
    {
	return "("+x+","+y+")";
    }
}
