package maslab.laser;

import java.io.*;
import java.net.*;
import java.util.*;

public class Sick implements LaserScanner
{
    Socket sock;
    ReaderThread reader;
    ArrayList<LaserListener> listeners=new ArrayList<LaserListener>();

    public Sick() throws UnknownHostException, IOException
    {
	sock=new Socket("localhost",7322);

	reader=new ReaderThread(sock);
	reader.start();
    }

    public synchronized void addLaserListener(LaserListener ll)
    {
	listeners.add(ll);
    }

    public synchronized void removeLaserListener(LaserListener ll)
    {
	if (listeners.contains(ll))
	    listeners.remove(ll);
    }

    class ReaderThread extends Thread
    {
	Socket sock;

	ReaderThread(Socket sock)
	{
	    this.sock=sock;
	}

	public void run()
	{
	    BufferedReader ins;

	    try {
		ins=new BufferedReader(new InputStreamReader(sock.getInputStream()));
	    } catch (IOException ex) {
		System.out.println("Got a crazy io exception");
		return;
	    }

	    while (true)
		{
		    try {
			String s=ins.readLine();
			if (s==null)
			    {
				System.out.println("lost connection to sickd.");
				return;
			    }
			StringTokenizer st=new StringTokenizer(s);
			
			if (!st.hasMoreTokens())
			    continue;

			String slength=st.nextToken();
			int length=Integer.parseInt(slength,16);

			double[] ranges=new double[length];

			int i;
			for (i=0;i<length && st.hasMoreTokens();i++)
			    {
				// data is in millimeters
				ranges[i]=Integer.parseInt(st.nextToken(),16)/1000.0;
			    }

			if (i!=length)
			    {
				System.out.println("not enough data");
				continue;
			    }

			LaserScanData scan=new LaserScanData(System.currentTimeMillis()/1000.0, ranges);
			notifyListeners(scan);

		    } catch (IOException ex) {
			System.out.println("IO Exception: "+ex);
		    }
		}
	}
	
    }


    protected synchronized void notifyListeners(LaserScanData scan)
    {
	for (LaserListener ll : listeners)
	    ll.processLaser(scan);
    }

    public static void main(String[] args)
    {
	try {
	    Sick s=new Sick();
	} catch (Exception ex) {
	    System.out.println("couldn't create sick "+ex);
	}

	while(true)
	    {
		try {
		    Thread.sleep(1000);
		} catch (InterruptedException ex) {
		}
	    }
    }

}
