package maslab.odom;

import maslab.geom.*;

public class OdomState
{
    public double x;
    public double y;
    public double theta;
    
    public OdomState()
    {
	x=0;
	y=0;
	theta=0;
    }

    public OdomState(double x, double y, double theta)
    {
	this.x=x;
	this.y=y;
	this.theta=theta;
    }

    public String toString()
    {
	return ""+x+" "+y+" "+theta;
    }

    /** Compute the odometry as though we started at the location given by os. **/
    public OdomState relativeTo(OdomState os)
    {
	OdomState newos=new OdomState();

	GPoint2D p=new GPoint2D(x-os.x, y-os.y);
	p=p.transform(0, 0, -os.theta);

	newos.x=p.getX();
	newos.y=p.getY();
	newos.theta=theta-os.theta;

	//	System.out.println(newos.x+" "+newos.y+" "+newos.theta);
	return newos;
    }

    public static void main(String args[])
    {
	OdomState os=new OdomState();
	os.x=1;
	os.y=1;
	os.theta=Math.PI/2;

	OdomState os2=new OdomState();
	os2.x=4;
	os2.y=2;
	os2.theta=Math.PI/4;
	
	System.out.println("os  "+os);
	System.out.println("os2 "+os2);
	System.out.println("os relative to os2 "+os.relativeTo(os2));
	System.out.println("os2 relative to os "+os2.relativeTo(os));

    }
}
