package maslab.orcspy;

import maslab.util.*;
import maslab.orc.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

public class GyroTest
{
    public static void main(String[] args)
    {
	Orc orc;

	try {
	    orc=new Orc();
	} catch (Exception ex) {
	    return;
	}

	Gyro gyro=new Gyro(orc);

	GetOpt opts=new GetOpt();
	opts.parse(args);
	ArrayList<String> extraArgs=opts.getExtraArgs();

	int trials=0;
	int seconds=8*60;

	double[] data=new double[seconds];

	FileWriter outs;

	try {
	    outs=new FileWriter(extraArgs.get(0));
	} catch (Exception ex) {
	    System.out.println("Couldn't open output file.");
	    return;
	}

	while(true)
	    {
		System.out.println("************** trial "+trials+" **************************");

		System.out.print("  Calibrating...");
		System.out.flush();
		gyro.calibrate(10000);
		System.out.println("...done");

		System.out.print("  ");
		for (int sec=0;sec<seconds;sec++)
		    {
			try {
			    Thread.sleep(1000);
			} catch (InterruptedException ex) {
			}

			data[sec]=gyro.getRadians();
			    
			System.out.print(" "+StringUtil.formatDouble(data[sec],5));
			System.out.flush();
		    }
		System.out.println("");

		try {
		    outs.write(StringUtil.formatDouble(2.5+5.0/65535*gyro.gyroCorrectionPerTick,5)+" ");
		    for (int sec=0;sec<seconds;sec++)
			{
			    outs.write(StringUtil.formatDouble(data[sec],5)+" ");
			}
		    outs.write("\n");
		    outs.flush();
		} catch (Exception ex) {
		    System.out.println("Error writing!");
		}

		trials++;
	    }
    }
}
