package maslab.orcspy;

import maslab.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

public class SignalPlot extends JPanel
{
    public static final long serialVersionUID=1001;

    class Sample
    {
	int     seqno;

	Color[] c;
	float[] v;
	String[]  l;
    }

    LinkedList<Sample> samples;

    int MAXIMUMHISTORY=150;
    int VERTICALBARSPACING=50;
    int LABELXMARGIN=2, LABELYMARGIN=1;

    int nextseqno=0;

    String label="";

    Color  labelbgcolor=new Color(0.2f, 0.2f, 0.2f, 0.7f);

    public SignalPlot()
    {
	samples=new LinkedList<Sample>();
    }

    public void setLabel(String l)
    {
	this.label=l;
	repaint();
    }

    public synchronized void paint(Graphics gin)
    {
	Graphics2D g=(Graphics2D) gin;

	int width=getWidth();
	if (width>MAXIMUMHISTORY)
	    MAXIMUMHISTORY=width;

	int height=getHeight();

	g.setColor(Color.black);
	g.fillRect(0,0,width,height);

	int x=width-1;

	for (Sample s: samples)
	    {
		if (s.seqno%VERTICALBARSPACING==0)
		    {
			g.setColor(Color.darkGray);
			g.drawLine(x, 0, x, height);
		    }

		for (int i=0;i<s.c.length;i++)
		    {
			float v=s.v[i];

			g.setColor(s.c[i]);
			int y=(int) (height-v*height);
			if (y<1)
			    y=1;
			if (y>=height-2)
			    y=height-2;

			g.drawLine(x, y, x, y);
		    }

		x--;
		if (x<0)
		    break;
	    }

	Font f=new Font("Helvetica", Font.PLAIN, 10);
	g.setFont(f);
	FontMetrics fm=g.getFontMetrics();
	int labelheight=fm.getMaxAscent();
	int labely=0;

	if (samples.size()==0)
	    return;

	Sample s=samples.getFirst();
	for (int i=0;i<s.c.length;i++)
	    {
		if (s.l[i]=="")
		    continue;

		int labelwidth=fm.stringWidth(s.l[i]);
		Rectangle2D.Float graybox=new Rectangle2D.Float(width-labelwidth-2*LABELXMARGIN,labely,
								labelwidth+2*LABELXMARGIN,
								labelheight+2*LABELYMARGIN);
		g.setColor(labelbgcolor);
		g.fill(graybox);
		g.setColor(s.c[i]);
		g.drawString(s.l[i], width-labelwidth-LABELXMARGIN, labely+labelheight+LABELYMARGIN);
		
		labely+=labelheight+1;
	    }
	
    }
    
    // A list of Colors and floats, e.g., c1, f1, c2, f2, ...
    public synchronized void addData(Object... args)
    {
	Sample s=new Sample();
	s.c=new Color[args.length/3];
	s.v=new float[args.length/3];
	s.l=new String[args.length/3];

	s.seqno=nextseqno++;
	if (nextseqno%VERTICALBARSPACING==0)
	    nextseqno=0;

	for (int i=0;i<args.length;i+=3)
	    {
		s.c[i/3]=(Color) args[i];
		if (args[i+1] instanceof Float)
		    s.v[i/3]=(Float) args[i+1];
		else if (args[i+1] instanceof Double)
		    s.v[i/3]=new Float((Double) args[i+1]);
		else
		    s.v[i/3]=0;

		if (args[i+2]!=null)
		    s.l[i/3]=(String) args[i+2];
		else
		    s.l[i/3]="";
	    }
	samples.addFirst(s);
	repaint();

	if (samples.size()>MAXIMUMHISTORY)
	    samples.removeLast();
    }
}
