package maslab.telemetry.botclient;

import javax.swing.*;
import java.awt.event.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
import javax.imageio.stream.*;
import java.util.*;
import maslab.telemetry.botclient.Plugin;
import maslab.util.*;

public class ImagePlugin implements Plugin, ActionListener
{
    static Logger log = new Logger("ImagePlugin");

    static final long serialVersionUID = 1001;

    static final int BUFFER_WIDTH = 640;  // This is the maximum frame size
    static final int BUFFER_HEIGHT = 480;

    BufferedImage i;
    ImageCanvas canvas;
    boolean paused = false;
    JButton pauseButton;
    JButton saveButton;
    JLabel colorLabel;
    JLabel redLabel,greenLabel,blueLabel,hueLabel,saturationLabel,brightnessLabel,xpixelLabel,ypixelLabel;
    JLabel fpsLabel;
    MouseColor mc;

    int currentType;
    static final int TYPE_JPEG = 1;
    static final int TYPE_RAW = 2;

    public static final String types = "jpegimage,rawimage";

    long fpsLastTime=0;
    int fpsFrameCount=0;
    int downsampling = 1;

    int leftpad=0;
    int toppad=0;
    int drawwidth=0;
    int drawheight=0;

    JInternalFrame frame;

    public ImagePlugin(JInternalFrame frame)
    {
	this.frame = frame;
	frame.setTitle("No Channel");
	frame.setResizable(true);

	i=new BufferedImage(BUFFER_WIDTH,BUFFER_HEIGHT,BufferedImage.TYPE_INT_ARGB);
	mc = new MouseColor();
	
	GridBagLayout gb2 = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();

	frame.getContentPane().setLayout(gb2);
	
	Container con=frame.getContentPane();

	canvas=new ImageCanvas();
	canvas.addMouseMotionListener(mc);
	canvas.addMouseListener(mc);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 0;
	c.weightx = 10;
	c.weighty = 10;
	c.ipadx = 0;
	c.ipady = 0;
	c.fill = GridBagConstraints.BOTH;
	c.anchor = GridBagConstraints.CENTER;
	con.add(canvas,c);


	JPanel panel = new JPanel();
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 1;
	c.weightx = 0;
	c.weighty = 0;
	c.ipadx = 0;
	c.ipady = 0;
	c.fill = GridBagConstraints.BOTH; // Change this to NONE to eliminate stretching
	c.anchor = GridBagConstraints.CENTER;
	con.add(panel,c);


	GridBagLayout gb = new GridBagLayout();
	panel.setLayout(gb);

	colorLabel = new JLabel();
	colorLabel.setPreferredSize(new Dimension(30,30));
	colorLabel.setOpaque(true);
	colorLabel.setBackground(Color.red);
	c.gridwidth = 1;
	c.gridheight = 2;
	c.gridx = 0;
	c.gridy = 0;
	c.weightx = 30;
	c.weighty = 30;
	c.ipadx = 10;
	c.ipady = 10;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.CENTER;
	gb.setConstraints(colorLabel,c);
	panel.add(colorLabel);

	redLabel = new JLabel("R:");
	redLabel.setPreferredSize(new Dimension(45,10));
	redLabel.setHorizontalAlignment(SwingConstants.LEFT);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 1;
	c.gridy = 0;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.WEST;
	gb.setConstraints(redLabel,c);
	panel.add(redLabel);
	

	greenLabel = new JLabel("G:");
	greenLabel.setPreferredSize(new Dimension(45,10));
	greenLabel.setHorizontalAlignment(SwingConstants.LEFT);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 2;
	c.gridy = 0;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.WEST;
	gb.setConstraints(greenLabel,c);
	panel.add(greenLabel);

	blueLabel = new JLabel("B:");
	blueLabel.setPreferredSize(new Dimension(45,10));
	blueLabel.setHorizontalAlignment(SwingConstants.LEFT);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 3;
	c.gridy = 0;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.WEST;
	gb.setConstraints(blueLabel,c);
	panel.add(blueLabel);


	hueLabel = new JLabel("H:");
	hueLabel.setPreferredSize(new Dimension(45,10));
	hueLabel.setHorizontalAlignment(SwingConstants.LEFT);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 1;
	c.gridy = 1;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.WEST;
	gb.setConstraints(hueLabel,c);
	panel.add(hueLabel);

	saturationLabel = new JLabel("S:");
	saturationLabel.setPreferredSize(new Dimension(45,10));
	saturationLabel.setHorizontalAlignment(SwingConstants.LEFT);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 2;
	c.gridy = 1;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.WEST;
	gb.setConstraints(saturationLabel,c);
	panel.add(saturationLabel);


	brightnessLabel = new JLabel("V:");
	brightnessLabel.setPreferredSize(new Dimension(45,10));
	brightnessLabel.setHorizontalAlignment(SwingConstants.LEFT);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 3;
	c.gridy = 1;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.WEST;
	gb.setConstraints(brightnessLabel,c);
	panel.add(brightnessLabel);

	fpsLabel = new JLabel("fps:0");
	fpsLabel.setPreferredSize(new Dimension(45,10));
	fpsLabel.setHorizontalAlignment(SwingConstants.LEFT);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 4;
	c.gridy = 1;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.WEST;
	gb.setConstraints(fpsLabel,c);
	panel.add(fpsLabel);

	xpixelLabel = new JLabel("X:");
	xpixelLabel.setPreferredSize(new Dimension(45,10));
	xpixelLabel.setHorizontalAlignment(SwingConstants.LEFT);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 4;
	c.gridy = 0;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.WEST;
	gb.setConstraints(xpixelLabel,c);
	panel.add(xpixelLabel);

	ypixelLabel = new JLabel("Y:");
	ypixelLabel.setPreferredSize(new Dimension(45,10));
	ypixelLabel.setHorizontalAlignment(SwingConstants.LEFT);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 5;
	c.gridy = 0;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.WEST;
	gb.setConstraints(ypixelLabel,c);
	panel.add(ypixelLabel);

	saveButton = new JButton("Save");
	saveButton.addActionListener(this);
	saveButton.setPreferredSize(new Dimension(100,10));
	c.gridwidth = 2;
	c.gridheight = 1;
	c.gridx = 6;
	c.gridy = 0;
	c.weightx = 30;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.EAST;
	gb.setConstraints(saveButton,c);
	panel.add(saveButton);

	pauseButton = new JButton("Pause");
	pauseButton.addActionListener(this);
	pauseButton.setPreferredSize(new Dimension(100,10));
	c.gridwidth = 2;
	c.gridheight = 1;
	c.gridx = 6;
	c.gridy = 1;
	c.weightx = 30;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.EAST;
	gb.setConstraints(pauseButton,c);
	panel.add(pauseButton);

	frame.pack();
	frame.setVisible(true);
    }


    public void actionPerformed(ActionEvent e)
    {
	String s = e.getActionCommand();
	if (s.equals("Pause"))
	    {
		pauseButton.setText("Resume");
		paused = true;
		return;
	    }

	if (s.equals("Resume"))
	    {
		pauseButton.setText("Pause");
		paused = false;
		return;
	    }

	if (s.equals("Save"))
	    {
		boolean oldpaused = paused;
		paused = true;
		int count = 0;
		File f = null;
		while (f == null || f.exists() == true)
		    {
			f = new File("capture" + count + ".png");
			count++;
		    }
		try{
		    ImageIO.write(i,"png",f);
		} catch(IOException ex){
		    JOptionPane.showMessageDialog(frame,"Error writing to " + f);
		}
		finally{
		    paused = oldpaused;
		}
	    }
    }



    public boolean addChannel(String name,String type)
    {
	if (frame.getTitle().equals("No Channel"))
	{
	    frame.setTitle(name);
	    if (type.equals("jpegimage"))
	       currentType = TYPE_JPEG;
	    if (type.equals("rawimage"))
		currentType = TYPE_RAW;
	    return true;
	}
	else
	    return false;
    }

    public void removeChannel(String name)
    {
	frame.setTitle("No Channel");
	currentType = 0;
    }

    public void messageReceived(String name,byte[] data)
    {
	if (!paused)
	    {
		try
		    {
			if (currentType == TYPE_JPEG)
			    handleJPEG(data);
			else if (currentType == TYPE_RAW)
			    handleRAW(data);
			else
			    log.warn("unknown image type: "+currentType);
		    }
		catch(IOException ioe){}
	    }
    }

    protected void updateFps()
    {
	long timeNow=System.currentTimeMillis();
	long elapsedTime=timeNow-fpsLastTime;

	fpsFrameCount++;
	if (fpsFrameCount > 10 || elapsedTime > 2000)
	    {
		float fps=fpsFrameCount/((float) elapsedTime/1000.0f);
		
		fpsFrameCount = 0;
		fpsLastTime = timeNow;
		fpsLabel.setText("fps:" + Math.round(fps*10)/10.0);
	    }
    }

    protected void handleJPEG(byte[] data) throws IOException
    {
	InputStream ins=new ByteArrayInputStream(data);
	i = ImageIO.read(ins);
	canvas.checkSize(i.getWidth(),i.getHeight());
	canvas.repaint();
	updateFps();
    }

    protected void handleRAW(byte[] data) throws IOException
    {
	DataInputStream dins = new DataInputStream(new ByteArrayInputStream(data));
	int w = dins.readInt();
	int h = dins.readInt();
	int d = dins.readInt();
	downsampling = dins.readInt(); // Only used for pixel coordinate display
	int inpos = 16;

	canvas.checkSize(w,h);

	int npixels=w*h;

	i=new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
	int rgb;
	
	int buf[] = ((DataBufferInt) i.getRaster().getDataBuffer()).getData();

	for (int bufpos=0;bufpos<npixels;bufpos++)
	    {
		int b=data[inpos++];
		int g=data[inpos++];
		int r=data[inpos++];
		r=r&0xff;
		g=g&0xff;
		b=b&0xff;
		rgb=0xff000000 | (r<<16) | (g<<8) | (b);
		
		buf[bufpos]=rgb;
	    }

	canvas.repaint();
	updateFps();
    }

    class MouseColor extends MouseAdapter implements MouseMotionListener
    {
	HueSaturationPlot hsp;
	int lastX=0;
	int lastY=0;
	int lastRawX=0;
	int lastRawY=0;

	public void mouseDragged(MouseEvent e){}


	public void mouseClicked(MouseEvent e)
	{
	    if (hsp == null)
		{
		    hsp = new HueSaturationPlot(150,3);
		    
		    if (BotClient.aDesktop != null)
			{
			    JInternalFrame f = new JInternalFrame("Hue/Saturation");
			    BotClient.aDesktop.add(f);
			    f.getContentPane().add(hsp);
			    f.pack();
			    f.addInternalFrameListener(new InternalFrameAdapter(){public void internalFrameClosing(InternalFrameEvent e){hsp = null;}});
			    f.setClosable(true);
			    f.setVisible(true);
			}
		    else
			{
			    JFrame f = new JFrame("Hue/Saturation");
			    f.getContentPane().add(hsp);
			    f.pack();
			    f.addWindowListener(new WindowAdapter(){public void windowClosing(WindowEvent e){hsp = null;}});
			    f.setVisible(true);
			}
		}

	    try{
	    Color c = new Color(i.getRGB(getRealX(e),getRealY(e)));
	    hsp.plotPoint(c);
	    }
	    catch(ArrayIndexOutOfBoundsException a){}
		
		
	    
	}

	int getRealX(MouseEvent e)
	{
	    ImageCanvas c = (ImageCanvas)e.getSource();
	    int x = e.getX();

	    x = (x-leftpad)*c.imageWidth/drawwidth;
	    
	    return x;
	}

	int getRealY(MouseEvent e)
	{
	    ImageCanvas c = (ImageCanvas)e.getSource();
	    int y = e.getY();

	    y = (y-toppad)*c.imageHeight/drawheight;

	    return y;
	}

	public void mouseMoved(MouseEvent e)
	{
	    int rgb;
	    int x = getRealX(e);
	    int y = getRealY(e);

	    lastX = x;
	    lastY = y;
	    lastRawX = e.getX();
	    lastRawY = e.getY();

	    try{
		rgb = i.getRGB(x,y);
	    }
	    catch(ArrayIndexOutOfBoundsException a){
		return;
	    }
	    
	    Color color = new Color(rgb);
	    colorLabel.setBackground(color);
	    colorLabel.repaint();

	    int red = color.getRed();
	    int blue = color.getBlue();
	    int green = color.getGreen();

	    float[] hsb = Color.RGBtoHSB(red,green,blue,null);

	    int hue = (int)(hsb[0]*255);
	    int saturation = (int)(hsb[1]*255);
	    int brightness = (int)(hsb[2]*255);
	    
	    redLabel.setText("R:" + red);
	    greenLabel.setText("G:" + green);
	    blueLabel.setText("B:" + blue);
	    hueLabel.setText("H:" + hue);
	    saturationLabel.setText("S:" + saturation);
	    brightnessLabel.setText("V:" + brightness);
	    xpixelLabel.setText("X:"+ (lastX*downsampling));
	    ypixelLabel.setText("Y:"+ (lastY*downsampling));
	    xpixelLabel.repaint();
	}

	public void redisplay()
	{
	    mouseMoved(new MouseEvent(canvas,0,(long)0,0,lastRawX,lastRawY,0,true));
	}
    }
    
    class ImageCanvas extends JPanel
    {
	public int imageWidth = 320;
	public int imageHeight = 240;
	boolean scaling = true;

	static final long serialVersionUID = 1001;
	
	public ImageCanvas()
	{
	    super();
	    setPreferredSize(new Dimension(imageWidth,imageHeight));
	    setSize(imageWidth,imageHeight);
	}

	public void paint(Graphics g)
	{
	    double aspect = i.getWidth()/((double) i.getHeight());
	    double width = getWidth();
	    double height = width/aspect;
	    if (height > getHeight())
		{
		    height = getHeight();
		    width = aspect*height;
		}
	    
	    if (scaling && (width > getWidth()))
		{
		    width = imageWidth;
		    height = imageHeight;
		}

	    g.setColor(Color.BLACK);
	    g.fillRect(0,0,getWidth(),getHeight());

	    leftpad=(int) (getWidth()-width)/2;
	    toppad=(int) (getHeight()-height)/2;
	    drawwidth=(int) width;
	    drawheight=(int) height;

	    g.drawImage(i,leftpad, toppad,
			(int) width, (int) height, null);
	    /*
	    if (scaling)
		g.drawImage(i,0,0,getWidth(),getHeight(),0,0,imageWidth,imageHeight,null);
	    else
		{
		    g.setColor(Color.BLACK);
		    g.fillRect(0,0,getWidth(),getHeight());
		    g.drawImage(i,0,0,imageWidth,imageHeight,0,0,imageWidth,imageHeight,null);
		}
	    */
	    mc.redisplay();
	}


	public void checkSize(int w, int h)
	{

	    if (w!=imageWidth || h!=imageHeight)
		{
		    int defaultW = w>320 ? w : 320;
		    int defaultH = h>240 ? h : 240;
		    canvas.setPreferredSize(new Dimension(defaultW,defaultH));
		    
		    canvas.setSize(defaultW,defaultH);
		    frame.pack();
		    imageWidth = w;
		    imageHeight = h;
		}
	}


    }



}
