package maslab.telemetry.channel;

import maslab.telemetry.*;
import maslab.util.*;

/** Abstract parent class for all channel types.  **/
public abstract class Channel
{
    static JugClient jc;
    static JugHub jh;

    String nametype;

    /** Ensures that the JugHub and JugClient have been
     * instantiated. **/
    static void assertInitialized()
    {
	if (jh == null)
	    {
		Logger.consolePublisher.setLevel("JugHub",Logger.WARN);
		Logger.consolePublisher.setLevel("JugClient",Logger.WARN);
		jh = new JugHub();
		jc = new JugClient();
	    }
    }

    /** Add a new listener to receive messages from the
     * BotClient.  
     @param listener A JugMessageListener object that will handle
     commands from the BotClient.   **/
    public static void addCommandListener(JugMessageListener listener)
    {
	assertInitialized();
	jc.subscribe("USERCMD$hidden",listener);
    }


}
