package maslab.telemetry.channel;

import java.io.*;

import maslab.telemetry.*;
import maslab.util.*;

/** Channel for displaying time-varying analog values to the
 * BotClient **/
public class ScopeChannel extends Channel
{
    static Logger log = new Logger("ScopeChannel");
    ByteArrayOutputStream buffer;

    /** Create a new ScopeChannel
	@param name The channel name **/
    public ScopeChannel(String name)
    {
	assertInitialized();
	nametype = name + "$" + "scope";
	jc.advertise(nametype);
	buffer = new ByteArrayOutputStream();
    }

    /** Plot a point on the time graph.
     @param value The value to send. **/
    public void publish(double value)
    {
	if (!jc.publishing(nametype))
	    return;
	DataOutputStream dos = new DataOutputStream(buffer);

	try{
	    dos.writeLong(System.currentTimeMillis());
	    dos.writeDouble(value);
	    jc.publish(nametype,buffer.toByteArray());
	}
	catch(IOException ioe){
	    log.log(Logger.WARN,"Error while publishing",ioe);
	}
	
	buffer.reset();
    }
}
