package maslab.telemetry.channel;

import maslab.telemetry.*;

/** Channel for publishing text messages to the BotClient **/
public class TextChannel extends Channel
{
    /** Create a new TextChannel
	@param name The channel name **/
    public TextChannel(String name)
    {
	assertInitialized();
	nametype = name + "$" + "text";
	jc.advertise(nametype);

    }

    /** Send a text message to the BotClient.  Newlines are not sent
     * automatically, so include your own "\n".  
     @param message The message to send. **/
    public void publish(String message)
    {
	jc.publish(nametype,message.getBytes());
    }
}
