package maslab.util;

/** A simple publisher for the Logger class that simply prints to the
 * console. Messages are filtered by a global level threshold and a
 * per-channel level threshold. If the message meets either criterion,
 * the message is published. 
 **/
public class ConsoleLoggerPublisher extends LoggerPublisher
{
    /** Create a new publisher with a default threshold of verbose. **/
    public ConsoleLoggerPublisher()
    {
    }

    /** Called when data is published. **/
    public synchronized void publish(String name, int level, String message)
    {
	// Avoid infinite loops resulting by error conditions by disallowing
	// error messages that WE might generate.
	if (reentry)
	    return;

	reentry=true;

	if (acceptingMessage(name, level))
	    {
		long nowTime=System.currentTimeMillis();
		double elapsedTime=(nowTime-Logger.startTime)/1000.0;
		String levelName=Logger.levelToString(level);

		System.out.println(StringUtil.padRight(name,20,' ') + 
				   StringUtil.padLeft(StringUtil.formatDouble(elapsedTime,3),10,' ') + " " +
				   StringUtil.padRight(levelName,10,' ') +
				   message);
	    }

	reentry=false;
    }
}
