package maslab.vis;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

/** An ellipse corresponding to a gaussian uncertainty (covariance). **/
public class VisGaussianEllipse extends VisEllipse
{
    public Color color=Color.yellow;
    
    /** 1-sigma confidence ellipse given the first and second moments
     */
    public VisGaussianEllipse(Color color, double x, double y, double cxx, double cxy, double cyy)
    {
	super(color, x, y, 0, 0, 0);

	solve(cxx,cxy,cyy);
    }

    /** Recompute ellipse parameters given covariance matrix.
     */
    protected void solve(double cxx, double cxy, double cyy)
    {
	double adbc=cxx*cyy-cxy*cxy;

	xx=cyy/adbc;
	xy=2*(-cxy/adbc);
	yy=cxx/adbc;
    }

    /** Set the paramters of the ellipse 
     */
    public void set(double x, double y, double cxx, double cxy, double cyy)
    {
	this.x=x;
	this.y=y;

	solve(cxx,cxy,cyy);
    }

}
