package maslab.vis;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

/** Labels an (x,y) point. **/
public class VisLabelledPoint extends VisObject
{
    public double x,y;
    public double size=6; // in pixels
    public double labelSize=12; // in pixels

    public String label;
    public Color color=Color.gray;

    public VisLabelledPoint(double x, double y, String label)
    {
	this.x=x;
	this.y=y;
	this.label=label;
    }

    public void paint(VisCanvas vc, Graphics2D g, BufferedImage bi)
    {
	double scale=vc.getScale();
	double sz=size/scale;

	g.setColor(color);
	g.fill(new Ellipse2D.Double(x-sz/2, y-sz/2, 
				    sz, sz)); 

	g.setFont(vc.getFont("Helvetica",Font.PLAIN, labelSize/scale));
	
	g.drawString(label, (float) (x+sz/2),(float) (y+sz/2));
    }

}
