package maslab.vis;

import maslab.util.*;
import maslab.geom.*;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.util.*;

/** A cloud of points. **/
public class VisPlot extends VisObject
{    
    public double size=6; // in pixels

    int lastx=0;
    java.util.List<GPoint2D> points=null;
    Color c;
    
    public enum LINESTYLE { DOTS, LINE, DASHEDLINE };

    LINESTYLE style;

    public VisPlot(Color c, LINESTYLE style, java.util.List<GPoint2D> points)
    {
	this.points=points;
	this.c=c;
	this.style=style;
    }

    public VisPlot(Color c, LINESTYLE style)
    {
	this.points=new ArrayList<GPoint2D>();
	this.c=c;
	this.style=style;

    }

    public void paint(VisCanvas vc, Graphics2D g, BufferedImage bi)
    {
	double scale=vc.getScale();

	double sz=size/scale;

	g.setColor(c);
	int nump=points.size();

	Ellipse2D.Double e=new Ellipse2D.Double(0,0,0,0);

	for (GPoint2D p : points)
	    {
		e.x=p.getX()-sz/2;
		e.y=p.getY()-sz/2;
		e.width=sz;
		e.height=sz;
		g.fill(e);
	    }
    }
}
