package maslab.vis;

import maslab.util.*;
import maslab.geom.*;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.util.*;

/** A cloud of points. **/
public class VisPointList extends VisObject
{
    public double size=6; // in pixels

    public Color color=Color.blue;
    
    public java.util.List<GPoint2D> points=new ArrayList<GPoint2D>();

    public VisPointList(Color c, java.util.List<GPoint2D> points)
    {
	this.points=points;
	this.color=c;
    }

    public VisPointList(Color c, double size)
    {
	this.color=c;
	this.size=size;
    }

    public void add(double x, double y)
    {
	points.add(new GPoint2D(x,y));
    }

    public void paint(VisCanvas vc, Graphics2D g, BufferedImage bi)
    {
	double scale=vc.getScale();

	double sz=size/scale;

	g.setColor(color);
	int nump=points.size();

	Ellipse2D.Double e=new Ellipse2D.Double(0,0,0,0);

	for (GPoint2D p : points)
	    {
		e.x=p.getX()-sz/2;
		e.y=p.getY()-sz/2;
		e.width=sz;
		e.height=sz;
		g.fill(e);
	    }
    }

}
