/*
 * Decompiled with CFR 0.152.
 */
package maslab.geom;

import Jama.Matrix;
import java.io.Serializable;
import maslab.geom.GPoint2D;

public class GLine2D
implements Cloneable,
Serializable {
    protected static GLine2D YAXIS = new GLine2D(0.0, 1.0, new GPoint2D(0.0, 0.0));
    protected static GLine2D XAXIS = new GLine2D(1.0, 0.0, new GPoint2D(0.0, 0.0));
    static final long serialVersionUID = 1001L;
    protected double dx;
    protected double dy;
    GPoint2D p;
    boolean normalizedSlope = false;
    boolean normalizedp = false;

    public GLine2D() {
        this.dx = 0.0;
        this.dy = 1.0;
        this.p = new GPoint2D(0.0, 0.0);
    }

    public void optimize() {
        this.normalizeSlope();
        this.normalizeP();
    }

    protected void normalizeSlope() {
        if (this.normalizedSlope) {
            return;
        }
        double mag = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        this.dx /= mag;
        this.dy /= mag;
        this.normalizedSlope = true;
    }

    public GLine2D(double dx, double dy, GPoint2D p) {
        this.dx = dx;
        this.dy = dy;
        this.p = p;
    }

    public GLine2D(double M, double b) {
        this.dx = 1.0;
        this.dy = M;
        this.p = new GPoint2D(0.0, b);
    }

    public GLine2D(GPoint2D p1, GPoint2D p2) {
        this.dx = p2.x - p1.x;
        this.dy = p2.y - p1.y;
        this.p = p1;
    }

    public double getM() {
        return this.dy / this.dx;
    }

    public double getB() {
        GPoint2D p = this.intersectionWith(YAXIS);
        return p.y;
    }

    public double getLineCoordinate(GPoint2D p) {
        this.normalizeSlope();
        return p.x * this.dx + p.y * this.dy;
    }

    public GPoint2D getPointOfCoordinate(double coord) {
        Matrix R = this.getR();
        GPoint2D p = new GPoint2D();
        this.normalizeSlope();
        p.x = R.get(0, 0) + coord * this.dx;
        p.y = R.get(1, 0) + coord * this.dy;
        return p;
    }

    public static GLine2D fromRmatrix(Matrix R) {
        GPoint2D p = new GPoint2D(R.get(0, 0), R.get(1, 0));
        double dx = -R.get(1, 0);
        double dy = R.get(0, 0);
        return new GLine2D(dx, dy, p);
    }

    public static GLine2D fromRTheta(double r, double theta) {
        double x = r * Math.cos(theta);
        double y = r * Math.sin(theta);
        double M = -1.0 / (y / x);
        double b = y - M * x;
        return new GLine2D(M, b);
    }

    public static GLine2D fromThetaPoint(double theta, GPoint2D p) {
        return new GLine2D(Math.cos(theta), Math.sin(theta), p);
    }

    public GLine2D perpendicularLine() {
        return new GLine2D(-this.dy, this.dx, this.p);
    }

    protected void normalizeP() {
        if (this.normalizedp) {
            return;
        }
        this.normalizeSlope();
        double dotprod = -this.dy * this.p.x + this.dx * this.p.y;
        this.p = new GPoint2D(-this.dy * dotprod, this.dx * dotprod);
        this.normalizedp = true;
    }

    public Matrix getR() {
        this.normalizeP();
        Matrix m = new Matrix(2, 1);
        m.set(0, 0, this.p.x);
        m.set(1, 0, this.p.y);
        return m;
    }

    public Matrix getU() {
        Matrix m = new Matrix(2, 1);
        m.set(0, 0, this.dx);
        m.set(1, 0, this.dy);
        return m.times(1.0 / m.normF());
    }

    public double getTheta() {
        return Math.atan2(this.dy, this.dx);
    }

    public GLine2D perpendicularLineThrough(GPoint2D pin) {
        return new GLine2D(-this.dy, this.dx, pin);
    }

    public GLine2D parallelLineThrough(GPoint2D pin) {
        return new GLine2D(this.dx, this.dy, pin);
    }

    public GPoint2D intersectionWith(GLine2D l) {
        double m00 = this.dx;
        double m11 = -l.dy;
        double m01 = -l.dx;
        double m10 = this.dy;
        double det = m00 * m11 - m01 * m10;
        if (Math.abs(det) < 1.0E-10) {
            return null;
        }
        double i00 = m11 / det;
        double i11 = m00 / det;
        double i01 = -m01 / det;
        double i10 = -m10 / det;
        double b00 = l.p.getX() - this.p.getX();
        double b10 = l.p.getY() - this.p.getY();
        double x00 = i00 * b00 + i01 * b10;
        return new GPoint2D(this.dx * x00 + this.p.getX(), this.dy * x00 + this.p.getY());
    }

    public GPoint2D pointOnLineClosestTo(GPoint2D pin) {
        this.normalizeSlope();
        this.normalizeP();
        double dotprod = pin.x * this.dx + pin.y * this.dy;
        return new GPoint2D(this.p.x + this.dx * dotprod, this.p.y + this.dy * dotprod);
    }

    public double perpendicularDistanceTo(GPoint2D pin) {
        GPoint2D pClosest = this.pointOnLineClosestTo(pin);
        return pClosest.distanceTo(pin);
    }

    public double distanceTo(GPoint2D p) {
        return this.perpendicularDistanceTo(p);
    }

    public String toString() {
        return "{Line through " + this.p + ", [" + this.dx + "," + this.dy + "]}";
    }

    public double getDistY(GPoint2D p0) {
        double x = p0.getX() - this.p.getX();
        double y = p0.getY() - this.p.getY();
        double s = x / this.dx;
        return y - s * this.dy;
    }

    public double getDistX(GPoint2D p0) {
        double x = p0.getX() - this.p.getX();
        double y = p0.getY() - this.p.getY();
        double s = y / this.dx;
        return x - s * this.dx;
    }

    public double getDx() {
        this.normalizeSlope();
        return this.dx;
    }

    public double getDy() {
        this.normalizeSlope();
        return this.dy;
    }

    public static void main(String[] args) {
        GLine2D l = new GLine2D(4.0, 10.0);
        GLine2D lperp = l.perpendicularLineThrough(GPoint2D.ORIGIN);
        double EPSILON = 1.0E-5;
        assert (Math.abs(lperp.getM() + 0.25) < EPSILON);
        assert (Math.abs(lperp.getB()) < EPSILON);
        System.out.println("" + l.p + " " + lperp + " " + l.perpendicularDistanceTo(new GPoint2D(4.0, 9.0)));
        assert (Math.abs(l.perpendicularDistanceTo(new GPoint2D(4.0, 9.0)) - 4.1231056256) < EPSILON);
        double c = l.getLineCoordinate(GPoint2D.ORIGIN);
        assert (Math.abs(c) < EPSILON);
        c = l.getLineCoordinate(new GPoint2D(2.0, 18.0));
        GPoint2D p = l.getPointOfCoordinate(c);
        assert (Math.abs(p.x - 2.0) < EPSILON);
        assert (Math.abs(p.y - 18.0) < EPSILON);
        System.out.println("\nAll tests passed. The next assertion should fail.\n");
        assert (false);
    }
}

