/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class JugPacket {
    public int command = 0;
    public String channelName = null;
    public byte[] data = null;
    public ByteArrayOutputStream bouts = null;
    public long timestamp = 0L;
    public static final int NOTICE_PONG = 100;
    public static final int NOTICE_ADV = 101;
    public static final int NOTICE_UNADV = 102;
    public static final int NOTICE_MSG = 103;
    public static final int NOTICE_SUBCOUNT = 110;
    public static final int COMMAND_PING = 0;
    public static final int COMMAND_ADV = 1;
    public static final int COMMAND_UNADV = 2;
    public static final int COMMAND_MSG = 3;
    public static final int COMMAND_LIST = 5;
    public static final int COMMAND_SUB = 6;
    public static final int COMMAND_UNSUB = 7;
    public static final int COMMAND_SUBCOUNT = 10;

    public JugPacket(DataInputStream ins) throws IOException {
        int datalen;
        this.command = ins.readShort();
        this.timestamp = ins.readLong();
        boolean hasChannelName = ins.readBoolean();
        if (hasChannelName) {
            short cnamelen = ins.readShort();
            byte[] cnamebytes = new byte[cnamelen];
            ins.readFully(cnamebytes);
            this.channelName = new String(cnamebytes);
        }
        if ((datalen = ins.readInt()) > 0) {
            this.data = new byte[datalen];
            ins.readFully(this.data);
        }
    }

    public JugPacket(int cmd) {
        this.command = cmd;
        this.timestamp = System.currentTimeMillis();
    }

    public JugPacket(int cmd, byte[] data) {
        this.command = cmd;
        this.data = data;
        this.timestamp = System.currentTimeMillis();
    }

    public JugPacket(int cmd, String cname) {
        this.command = cmd;
        this.channelName = cname;
        this.timestamp = System.currentTimeMillis();
    }

    public JugPacket(int cmd, String cname, byte[] data) {
        this.command = cmd;
        this.channelName = cname;
        this.data = data;
        this.timestamp = System.currentTimeMillis();
    }

    public void write(DataOutputStream outs) throws IOException {
        outs.writeShort(this.command);
        outs.writeLong(this.timestamp);
        outs.writeBoolean(this.channelName != null);
        if (this.channelName != null) {
            outs.writeShort(this.channelName.length());
            outs.writeBytes(this.channelName);
        }
        outs.writeInt(this.size());
        if (this.data != null) {
            outs.write(this.data);
        }
        if (this.bouts != null) {
            outs.write(this.bouts.toByteArray());
        }
        outs.flush();
    }

    public DataInputStream getDataInputStream() throws IOException {
        return new DataInputStream(new ByteArrayInputStream(this.data));
    }

    public DataOutputStream getDataOutputStream() throws IOException {
        this.bouts = new ByteArrayOutputStream();
        return new DataOutputStream(this.bouts);
    }

    public int size() {
        int length = 0;
        if (this.data != null) {
            length += this.data.length;
        }
        if (this.bouts != null) {
            length += this.bouts.size();
        }
        return length;
    }
}

