/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import org.orcboard.orc.Orc;

public class ADIS16250 {
    Orc orc;
    static final byte SPI_FLAGS = 30;
    double accumulator = 0.0;
    double drift_deg_per_sec = 0.0;
    double last_reading = 0.0;
    long last_reading_time = -1L;

    public ADIS16250(Orc orc) {
        this.orc = orc;
    }

    int readRegister(int addr) {
        byte[] resp;
        while ((resp = this.orc.doTransactionRetry(new byte[]{22, 3, 30, (byte)addr, 0})) != null && resp.length == 1 && resp[0] == 6) {
        }
        if (resp == null || resp.length != 3 || resp[0] != 0) {
            System.out.println("read err: " + addr + " " + resp.length);
            return -1;
        }
        while ((resp = this.orc.doTransactionRetry(new byte[]{22, 3, 30, (byte)addr, 0})) != null && resp.length == 1 && resp[0] == 6) {
        }
        if (resp == null || resp.length != 3 || resp[0] != 0) {
            System.out.println("read err: " + addr);
            return -1;
        }
        return (resp[1] & 0xFF) << 8 | resp[2] & 0xFF;
    }

    int writeRegister(int addr, int val) {
        byte[] resp;
        while ((resp = this.orc.doTransactionRetry(new byte[]{22, 3, 30, (byte)(0x80 | addr), (byte)val})) != null && resp.length == 1 && resp[0] == 6) {
        }
        if (resp == null || resp.length != 3 || resp[0] != 0) {
            System.out.println("write err: " + addr);
            return -1;
        }
        return 0;
    }

    public double readRaw() {
        int v = this.readRegister(14);
        return (double)(v &= 0x3FFF) * 0.03663;
    }

    public double read() {
        double reading = this.readRaw();
        long reading_time = System.nanoTime();
        if (this.last_reading_time > 0L) {
            double dt = (double)(reading_time - this.last_reading_time) / 1.0E9;
            double ddeg = reading - this.last_reading;
            if (ddeg > 180.0) {
                ddeg -= 360.0;
            }
            if (ddeg < -180.0) {
                ddeg += 360.0;
            }
            this.accumulator += ddeg - this.drift_deg_per_sec * dt;
        }
        this.last_reading_time = reading_time;
        this.last_reading = reading;
        return this.accumulator;
    }

    public void beginCalibration(double seconds) {
        new CalibThread(seconds).start();
    }

    public void calibrate(double seconds) {
        CalibThread ct = new CalibThread(seconds);
        ct.start();
        try {
            ct.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public void reset() {
        this.accumulator = 0.0;
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        ADIS16250 gyro = new ADIS16250(orc);
        System.out.println("Calibrating");
        gyro.calibrate(20.0);
        gyro.reset();
        long starttime = System.currentTimeMillis();
        while (true) {
            System.out.printf("%15.3f %10.3f %10.3f\n", (double)(System.currentTimeMillis() - starttime) / 1000.0, gyro.readRaw(), gyro.read());
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex);
                continue;
            }
            break;
        }
    }

    class CalibThread
    extends Thread {
        double sec;

        public CalibThread(double sec) {
            this.sec = sec;
        }

        @Override
        public void run() {
            double start = ADIS16250.this.readRaw();
            long starttime = System.nanoTime();
            try {
                Thread.sleep((int)(this.sec * 1000.0));
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            double end = ADIS16250.this.readRaw();
            long endtime = System.nanoTime();
            double dt = (double)(endtime - starttime) / 1.0E9;
            ADIS16250.this.drift_deg_per_sec = (end - start) / dt;
        }
    }
}

