/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import org.orcboard.orc.Orc;
import org.orcboard.orcspy.WaveformSettings;
import org.orcboard.orcspy.WaveformSource;

public class DigitalInput
implements WaveformSource {
    Orc orc;
    int port;
    boolean invert = false;

    public DigitalInput(Orc orc, int port) {
        this(orc, port, false);
    }

    public DigitalInput(Orc orc, int port, boolean invert) {
        this.orc = orc;
        assert (port >= 0 && port <= 23);
        this.port = port;
        this.invert = invert;
    }

    public boolean read() {
        int mask;
        int idx;
        byte[] resp = this.orc.doTransactionRetry(new byte[]{10});
        int v = resp[idx = 1 + this.port / 8] & (mask = 1 << (this.port & 7));
        return v != 0 ^ this.invert;
    }

    @Override
    public double getWaveformSample() {
        return this.read() ? 1.0 : 0.0;
    }

    @Override
    public WaveformSettings getDefaultWaveformSettings() {
        return new WaveformSettings("Digital In " + this.port, "", 0.0, 1.0, 0.5);
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        DigitalInput in = new DigitalInput(orc, 0);
        while (true) {
            System.out.println(in.read());
            Orc.safesleep(100);
        }
    }
}

