/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.orcboard.orc.Orc;
import org.orcboard.orc.OrcConnection;
import org.orcboard.orc.Packet;

public class OrcTCPConnection
implements OrcConnection {
    DataOutputStream douts = null;
    DataInputStream dins = null;
    String host;
    int port;

    public OrcTCPConnection() {
        this("localhost", 7000);
    }

    public OrcTCPConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public synchronized void writePacket(Packet p) {
        try {
            if (this.douts == null) {
                return;
            }
            this.douts.writeByte(237);
            this.douts.writeByte(p.getId());
            this.douts.writeByte(p.getDataLength());
            this.douts.write(p.data, 0, p.getDataLength());
            this.douts.writeByte(p.getChecksum());
            this.douts.flush();
        }
        catch (Exception ex) {
            return;
        }
    }

    @Override
    public Packet readPacket() {
        while (true) {
            try {
                int c;
                do {
                    if ((c = this.dins.read()) >= 0) continue;
                    throw new IOException();
                } while (c != 237);
                int id = this.dins.read() & 0xFF;
                int len = this.dins.read() & 0xFF;
                if (len == 0) {
                    return null;
                }
                byte[] data = new byte[len];
                this.dins.readFully(data);
                int chk = this.dins.read() & 0xFF;
                Packet p = new Packet(id, data);
                if (chk != 222 && chk != p.getChecksum()) {
                    return null;
                }
                return p;
            }
            catch (Exception ex) {
                try {
                    System.out.println("Reconnecting");
                    this.douts = null;
                    this.dins = null;
                    Socket s = new Socket(this.host, this.port);
                    s.setTcpNoDelay(true);
                    this.dins = new DataInputStream(s.getInputStream());
                    this.douts = new DataOutputStream(s.getOutputStream());
                    continue;
                }
                catch (Exception ex2) {
                    Orc.safesleep(250);
                    continue;
                }
            }
            break;
        }
    }
}

