/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orcspy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.orcboard.orc.AnalogInput;
import org.orcboard.orc.Orc;
import org.orcboard.orcspy.WaveformSettings;
import org.orcboard.orcspy.WaveformSource;

public class Oscilloscope
extends JPanel {
    ArrayList<Channel> channels = new ArrayList();
    int yGridSize = 100;
    int xGridSize = 100;
    int xUnitNotches = 0;
    static final int xMinNotch = -9;
    static final int xMaxNotch = 8;
    static final int yMinNotch = -12;
    static final int yMaxNotch = 15;
    public static final int HISTORY_SIZE = 500;
    public static final Color[] colors = new Color[]{Color.cyan, Color.red, Color.blue, Color.black};
    Channel selectedChannel = null;
    int textHeight = 15;
    int channelLabelHeight = 50;
    int channelLabelWidth = 200;

    public Oscilloscope() {
        new UpdateThread().start();
        MouseHandler mh = new MouseHandler();
        this.addMouseMotionListener(mh);
        this.addMouseListener(mh);
    }

    public void addWaveform(WaveformSource source) {
        Channel channel = new Channel();
        channel.source = source;
        channel.settings = source.getDefaultWaveformSettings();
        channel.vals = new Sample[500];
        channel.color = colors[this.channels.size() % colors.length];
        for (int i = 0; i < channel.vals.length; ++i) {
            channel.vals[i] = new Sample();
        }
        channel.yOffset = (channel.settings.defaultYmin + channel.settings.defaultYmax) / 2.0;
        channel.yUnitNotches = Oscilloscope.rangeToNotches(channel.settings.defaultYmax - channel.settings.defaultYmin);
        this.channels.add(channel);
        if (this.channels.size() == 1) {
            this.selectedChannel = channel;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics _g) {
        Graphics2D g = (Graphics2D)_g;
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(Color.darkGray);
        g.fillRect(0, 0, width, height);
        double rightTime = (double)System.currentTimeMillis() / 1000.0;
        double xUnit = Oscilloscope.notchToScale(this.xUnitNotches);
        g.setFont(new Font("Monospaced", 0, 12));
        g.setColor(Color.gray);
        for (int x = width; x >= 0; x -= this.xGridSize) {
            g.drawLine(x, 0, x, height);
        }
        for (int dy = 0; dy < height / 2; dy += this.yGridSize) {
            g.drawLine(0, height / 2 + dy, width, height / 2 + dy);
            g.drawLine(0, height / 2 - dy, width, height / 2 - dy);
        }
        int labely = 0;
        for (Channel channel : this.channels) {
            int lastx = 99999999;
            int lasty = 99999999;
            double yUnit = Oscilloscope.notchToScale(channel.yUnitNotches);
            g.setColor(channel.color);
            for (int i = 0; i <= channel.vals.length; ++i) {
                int j = i == channel.vals.length ? 0 : i;
                Sample s = channel.vals[j];
                if (s.time < 0.0) continue;
                int x = (int)((double)width - (rightTime - s.time) / xUnit * (double)this.xGridSize);
                int y = (int)((double)(height / 2) - (s.value - channel.yOffset) / yUnit * (double)this.yGridSize);
                if (x >= lastx) {
                    g.drawLine(lastx, lasty, x, y);
                } else {
                    g.drawLine(x, y, x + 1, y);
                }
                lastx = x;
                lasty = y;
            }
            String label = String.format("%-15s %8.3f %s", channel.settings.name, channel.lastValue, channel.settings.units);
            if (this.channels.size() > 1) {
                if (channel == this.selectedChannel) {
                    g.setColor(new Color(255, 255, 0, 20));
                } else {
                    g.setColor(new Color(0, 0, 0, 20));
                }
                g.fill(new Rectangle2D.Double(0.0, labely, this.channelLabelWidth, this.channelLabelHeight));
            }
            g.setColor(channel.color);
            g.drawString(label, 0, labely + this.textHeight);
            g.drawString(Oscilloscope.notchToString(channel.yUnitNotches) + channel.settings.units + " / VDIV", 0, labely + 2 * this.textHeight);
            labely += this.channelLabelHeight;
        }
        g.setColor(Color.gray);
        g.drawString(Oscilloscope.notchToString(this.xUnitNotches) + "s / HDIV", width - 95, this.textHeight);
    }

    static int clamp(int a, int min, int max) {
        if (a < min) {
            a = min;
        }
        if (a > max) {
            a = max;
        }
        return a;
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        Oscilloscope osc = new Oscilloscope();
        osc.addWaveform(new AnalogInput(orc, 16));
        JFrame frame = new JFrame();
        frame.setLayout(new BorderLayout());
        frame.add((Component)osc, "Center");
        frame.setVisible(true);
        frame.setSize(600, 400);
    }

    public static final int rangeToNotches(double range) {
        double powOfTen = Math.log(Math.abs(range)) / Math.log(10.0);
        int iPowOfTen = (int)powOfTen;
        double rem = powOfTen - (double)iPowOfTen;
        return (int)(powOfTen * 3.0);
    }

    public static final double notchToScale(int pos) {
        double scale = 1.0;
        int powOfTen = pos >= 0 ? pos / 3 : (pos - 2) / 3;
        int rem = pos % 3;
        if (rem < 0) {
            rem += 3;
        }
        scale *= Math.pow(10.0, powOfTen);
        if (rem == 1) {
            scale *= 2.0;
        } else if (rem == 2) {
            scale *= 5.0;
        }
        return scale;
    }

    public static final String notchToString(int pos) {
        int powOfTen = pos >= 0 ? pos / 3 : (pos - 2) / 3;
        int rem = pos % 3;
        if (rem < 0) {
            rem += 3;
        }
        String mag = "";
        if (powOfTen >= 9) {
            mag = "G";
            powOfTen -= 9;
        } else if (powOfTen >= 6) {
            mag = "M";
            powOfTen -= 6;
        } else if (powOfTen >= 3) {
            mag = "k";
            powOfTen -= 3;
        } else if (powOfTen < -12) {
            mag = "f";
            powOfTen += 15;
        } else if (powOfTen < -9) {
            mag = "p";
            powOfTen += 12;
        } else if (powOfTen < -6) {
            mag = "n";
            powOfTen += 9;
        } else if (powOfTen < -3) {
            mag = "u";
            powOfTen += 6;
        } else if (powOfTen < 0) {
            mag = "m";
            powOfTen += 3;
        }
        double scale = Math.pow(10.0, powOfTen);
        if (rem == 1) {
            scale *= 2.0;
        } else if (rem == 2) {
            scale *= 5.0;
        }
        return scale + " " + mag;
    }

    class UpdateThread
    extends Thread {
        UpdateThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            int count = 0;
            long countStartTime = System.currentTimeMillis();
            while (true) {
                long timenow;
                try {
                    double xUnit = Oscilloscope.notchToScale(Oscilloscope.this.xUnitNotches);
                    double twidth = xUnit * (double)Oscilloscope.this.getWidth() / (double)Oscilloscope.this.xGridSize;
                    int delayms = (int)(1000.0 * twidth / 500.0);
                    if (delayms > 1000) {
                        delayms = 1000;
                    }
                    Thread.sleep(delayms);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                for (Channel channel : Oscilloscope.this.channels) {
                    channel.vals[channel.valfirst].value = channel.lastValue = channel.source.getWaveformSample();
                    channel.vals[channel.valfirst].time = (double)System.currentTimeMillis() / 1000.0;
                    ++channel.valfirst;
                    if (channel.valfirst != channel.vals.length) continue;
                    channel.valfirst = 0;
                }
                Oscilloscope.this.repaint();
                if (++count <= 1000) continue;
                countStartTime = timenow = System.currentTimeMillis();
                count = 0;
            }
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        Point dragBegin = null;

        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragBegin = e.getPoint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.dragBegin = null;
            Point p = e.getPoint();
            if (p.getX() < (double)Oscilloscope.this.channelLabelWidth) {
                if (e.getClickCount() == 1) {
                    int idx = (int)(p.getY() / (double)Oscilloscope.this.channelLabelHeight);
                    if (idx < Oscilloscope.this.channels.size()) {
                        Oscilloscope.this.selectedChannel = Oscilloscope.this.channels.get(idx);
                        Oscilloscope.this.repaint();
                    }
                } else if (e.getClickCount() == 2) {
                    Oscilloscope.this.selectedChannel.yOffset = Oscilloscope.this.selectedChannel.source.getWaveformSample();
                    Oscilloscope.this.repaint();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dragBegin = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int mods = e.getModifiersEx();
            boolean shift = (mods & 0x40) > 0;
            boolean ctrl = (mods & 0x80) > 0;
            boolean alt = shift & ctrl;
            ctrl &= !alt;
            shift &= !alt;
            if (this.dragBegin == null) {
                this.dragBegin = e.getPoint();
                return;
            }
            if ((mods & 0x400) > 0) {
                double yUnit = Oscilloscope.notchToScale(Oscilloscope.this.selectedChannel.yUnitNotches);
                int dy = (int)(e.getPoint().getY() - this.dragBegin.getY());
                double ddy = (double)dy * yUnit / (double)Oscilloscope.this.yGridSize;
                Oscilloscope.this.selectedChannel.yOffset += ddy;
                this.dragBegin = e.getPoint();
            } else {
                int thresh = 10;
                int dx = (int)(e.getPoint().getX() - this.dragBegin.getX());
                int dy = (int)(e.getPoint().getY() - this.dragBegin.getY());
                if (dx > thresh) {
                    --Oscilloscope.this.xUnitNotches;
                    this.dragBegin = e.getPoint();
                }
                if (dx < -thresh) {
                    ++Oscilloscope.this.xUnitNotches;
                    this.dragBegin = e.getPoint();
                }
                if (dy > thresh) {
                    --Oscilloscope.this.selectedChannel.yUnitNotches;
                    this.dragBegin = e.getPoint();
                }
                if (dy < -thresh) {
                    ++Oscilloscope.this.selectedChannel.yUnitNotches;
                    this.dragBegin = e.getPoint();
                }
                Oscilloscope.this.xUnitNotches = Oscilloscope.clamp(Oscilloscope.this.xUnitNotches, -9, 8);
                Oscilloscope.this.selectedChannel.yUnitNotches = Oscilloscope.clamp(Oscilloscope.this.selectedChannel.yUnitNotches, -12, 15);
            }
            Oscilloscope.this.repaint();
        }
    }

    class Channel {
        WaveformSource source;
        WaveformSettings settings;
        double lastValue;
        Sample[] vals;
        int valfirst = 0;
        Color color = Color.yellow;
        int yUnitNotches = 1;
        double yOffset = 0.0;

        Channel() {
        }
    }

    class Sample {
        double value;
        double time = -1.0;

        Sample() {
        }
    }
}

