				/* device driver for the NeWS window system */
#include <stdio.h>
#include <signal.h>
#include "S.h"
#include "device.h"
#include "psio.h"
#include "ok_news.h"

#define DNAME news
#include "disp_list.h"
     
     /* USER-TO-RASTER AND RASTER-TO-USER CONVERSIONS 
      * note that all high-level device routines get user coordinates
      * may need to transform them to rasters for plotting
      * user-to-raster and raster-to-user conversions
      */

#define Xorigin		(am(36))
#define Yorigin		(am(38))
#define Xscale		(am(37))
#define Yscale		(am(39))
#define UxR(x)		((int)((x) * Xscale + Xorigin))
#define UyR(y)		((int)((y) * Yscale + Yorigin))
#define RxU(x)		(((x) - Xorigin) / Xscale)
#define RyU(y)		(((y) - Yorigin) / Yscale)
     
static int sequence = 0;
static int ask, button, menu_index, xyin_x, xyin_y;
static void tagreads(), alarmCatcher();

vector *alcvec(), *coevec();

/* DEVICE DRIVER INITIALIZATION 
 *   initialize device structure and graphical parameters 
 */

vector *DNAME(pointsize, iask, display)
    long *pointsize, *iask;
    char **display;
{
  device *new_device();
  int i;
  signal(SIGALRM,alarmCatcher);
				/* initialize device structure and */
				/* graphical parameters  */
  set_device(new_device(&d_DNAME, 0L)->which);

  if( display != NULL && *display != NULL && *display[0] != '\0' )
  {
	/* ps_open_PostScript provides no way of overriding the
	 * environment, so we have to mung the environment.  Yech!
	 */
	if( setenv("NEWSSERVER", *display, 1) != 0)
		Recover("Cannot set server name",S_void);
  }
  if (ps_open_PostScript()==0)
    Recover("Cannot Connect to NeWS server",S_void);

  initDisplayList(); 

  for (i=1; i<=39; i++)
    am(i) = 0;
  am(20) = *pointsize*.65;	/* character size */
  am(21) = *pointsize*1.2;
  am(22) = 0;                  /* dummy values for initial window */
  am(23) = 500; 
  am(24) = 0; 
  am(25) = 500; 
  am(26) = 0;			/* character addressing offset */
  am(27) = 0;
  am(28) = 1./72.;		/* raster size in inches */
  am(29) = am(28);
  am(30) = NEWS;		/* some magic negative number */
  am(31) = 0;			/* characters do not rotate (temporarily) */
  am(1) = 1;			/* characters scale */
  F77_SUB(defltz)();		/* set other parameters */
  ps_initialize();		/* set up and send dimension tag */
  ps_send_me_tag(++sequence);	/* make sure there is a tag on the */
				/* stack so tagreads() breaks the loop */
  tagreads();			/* get dimensions */
  ask = *iask;
  ALARM_YES;
}

static void USRamodes(ii)
     int ii;
{
  switch(ii)
  {
  case  8:   ps_set_line_type((int) am(8));        /* line type */           
             break; 
  case  9:   ps_set_line_width(am(9));             /* line width */          
             break; 
  case 10:   ps_set_gray((int) am(10));			/* color */
	     break;
  case 15:   ps_set_plot_char((int) am(15));       /* plot character */      
             break; 
  case 18:   ps_set_cex(am(18));                   /* character expansion */ 
             break; 
  case 48:   ps_set_srt(am(48));                   /* string rotation */     
             break; 
  }
}
    
static void USRtext(x, y, buf, pos)
     float *x, *y, pos;
     char buf[];
{
  ps_show_text(buf, UxR(*x), UyR(*y), pos);
  psio_flush(PostScript);
}

static void USRmrks(xx, yy, n)
     float *xx, *yy;
     int n;
{
  long pch = (long)am(15);
  
  /* if plotting character is less than 32, then call special routine
     to draw plotting symbols rather than characters */
  if(pch < 32)
    F77_SUB(dmarkz)(xx, yy, n, &pch);
  else
  while(n--)
      ps_plot_mark(UxR(*xx++),UyR(*yy++));
  psio_flush(PostScript); 
}

static void USRlins(x, y, n)
     float *x, *y;
     int n;
{  
  ps_moveto(UxR(*x++), UyR(*y++));
  while(--n)
    ps_lineto(UxR(*x++),UyR(*y++));
  ps_stroke();
  psio_flush(PostScript);
}

static void USRpoly(x, y, n)
     float *x, *y;
     int n;
{
  ps_moveto(UxR(*x++), UyR(*y++)); 
  while(--n)
    ps_lineto(UxR(*x++), UyR(*y++));
  ps_closepath();
  ps_fill_path();
  psio_flush(PostScript);
}

static void USRsegs(x1, y1, x2, y2, n)
     float *x1, *y1, *x2, *y2;
     int n;
{
  while(n--) {
    ps_moveto(UxR(*x1++),UyR(*y1++));
    ps_lineto(UxR(*x2++),UyR(*y2++));
    ps_stroke();
  }
  psio_flush(PostScript); 
}

/* OTHER ROUTINES CALLED BY S
 *
 * flush() brings the output up to date
 * clear() prints the current page
 * wrap() wraps up the job
 * signalled() fixes up if interrupt or other signal occurs
 */

static void USRflush()
{
  psio_flush(PostScript); 
}

static void 
USRclear(redraw)
int redraw;
{
  ALARM_NO;
  if( ask && !redraw ) {
    Eprintf("GO? ");
    ALARM_YES;
    while( getchar()!='\n' );
    ALARM_NO;
  }
  ps_clear();
  ALARM_YES;
}

static void USRwrap()
{
  ps_close_PostScript();
}

static void USRsignalled()
{
  psio_flush(PostScript); 
}

/*
 * ADDITIONAL FUNCTION CALLS FROM S
 */

static void USRinput(x, y, n, nmax)
     float x[], y[];
     long *n, *nmax;
{
  int i;

  ALARM_NO;
  ps_input_setup();
  for (i = 0; i < *nmax; i++) {
    button = 0;
    tagreads();
    if(!button) {
      ps_input_shutdown();
      Recover("Graphic input got out of sync", S_void);
    }
    *x++ = RxU(xyin_x); *y++ = RyU(xyin_y);
    if(button != 1) break;
  }
  *n = i;
  ps_input_shutdown();
  ALARM_YES;
}

static vector *USRmenu(ent,arglist)
     vector *ent, *arglist;
{
  vector *value;
  int i;
  
  ALARM_NO;
  value = coevec(*(arglist->value.tree),ANY,TRUE,CHECK_IT);
  if(value==NULL_ENTRY) return(S_void);
  value = coevec(value,CHAR,TRUE,CHECK_IT);
  
  for(i=value->length-1; i>=0; i--) /* Add items */
    ps_add_menu_item(value->value.Char[i]);
  ps_modify_menu_null();	/* Add action to null */
  psio_flush(PostScript);
  Eprintf("Use MenuButton in S graphics window\n");
  tagreads();			/* Return the selection */
  value = alcvec(INT,1L);
  *(value->value.Long) = menu_index;
  ps_menu_reset();		/* Reset menu to null */
  psio_flush(PostScript); 
  ALARM_YES;
  return(value);
}

static void USRhook()
{
  printf("Hook\n");
}

static void USRlength()
{
  printf("Length\n");
}

/* tagreads and alarmCatcher */
      
static void tagreads()
{
  int redrawFlag = 0;
  
  while(!psio_eof(PostScript)) {
    if (ps_xy_input(&xyin_x, &xyin_y, &button)) 
      break;
    else if (ps_menu_hit(&menu_index))
      break;
    else if (ps_get_dimensions(&am(22),&am(24),	 /* (x,y) of origin */
			       &am(23),&am(25))) /* (x,y) of corner */
      redrawFlag = 1;
    else if (ps_last_event())
      break;
    else {
      Eprintf("Weird tag in input queue\n");
      break; 
    }
  }
  if (redrawFlag) {
    ask = 0;
    redrawDisplayList();
    ask = 1;
  }
}

static void alarmCatcher()
{
  ALARM_NO;
#ifndef Berkeley
  signal(SIGALRM,alarmCatcher);
#endif
  ps_send_me_tag(++sequence);
  tagreads();
  ALARM_YES;
}    

static void
USRamReset()
{
	/* may need to do something here */
}
