extern int nspec;
#include <ctype.h>
#include <sgtty.h>
#define NOEXTERN
#include "color.h"
#include "aed.h"

char *def_specs[] =
{
	"0,blue,31,60", /* dark blue */
	"1,cyan",
	"2,green",
	"3,yellow",
	"4,blue",
	"5,magenta",
	"6,red",
	"7,0,100,0", /* white */
	"8,0,0,0", /* black */
	"20-35,gray",
	"50-89,blue-blue",
	0
};

static int started = 0;

main(argc, argv)
char **argv;
{
	int force_write, fill_aed, i;
	char next_cmd(), *dfcn(), *cursor();
	int cwrapup();
	char *word, *s, c, *p, **pp;

	readfile = writefile = COLORFILE;
	pal_drawn = circle_drawn = 0;
	fill_aed = def_setup = 1;
	force_write = no_seq = 0;
	interactive = 1;
	changed = 0;

	if(--argc) while(argc--) {
		word = *(++argv);
		if(word[0] == '-') switch(word[1]) {
		case 'f':
			fill_aed = 0;
			def_setup = 0;
			break;
		case 'p':
			pal_drawn++;
			break;
		case 'i':
			interactive = 0;
			break;
		case 's':
			no_seq++;
			break;
		case 'r':
			if(argc && argv[1][0] != ',' && argv[1][0] != '-' && !isdigit(argv[1][0])) {
				read_Col(*(++argv));
				argc--;
			} else
				read_Col(readfile);
			def_setup = 0;
			break;
		case 'w':
			if(argc && argv[1][0] != ',' && argv[1][0] != '-' && !isdigit(argv[1][0])) {
				writefile = *(++argv);
				argc--;
			}
			force_write++;
			break;
		} else {
			def_setup = 0;
			if((i = process(word, NO)) == 0)
				printf("bad specification string: '%s'\n", word);
			else if(!no_seq && i > 1)
				addspec(word);
		}
	}
	if(def_setup)
		for(pp = def_specs; *pp; pp++) {
			i = process(*pp, NO);
			if(!no_seq && i > 1)
				addspec(*pp);
		}
	if(interactive || fill_aed)
		started = startup(cwrapup);
	if(fill_aed)
		fill_table();
	if(interactive)
		dinit();
	else {
		if(force_write)
			write_Col(writefile);
		cwrapup();
	}
	for(;;) {
		if(changed) {
			set_table(cur_color, Colors[cur_color].HLS);
			changed = 0;
		}
		switch(c = next_cmd("command?")) {
		case SHELL:
			if(word = dfcn("shell command", YES))
				system(word);
			break;
		case SPECIFICATION:
			if(word = dfcn("specification", YES)) {
				while((i = process(word, YES)) == 0)
					word = dfcn("try again", YES);
				if(!no_seq && i > 1)
					addspec(word);
				dnumber(cur_color);
			}
			break;
		case NUM_PALETTE:
		case NUM_PICTURE:
		case NUM_NUM:
			dnumber(cur_color = pick(c));
			break;
		case MIX_CIRCLE:
		case MIX_VIRT:
		case MIX_SAME:
			mix(c);
			break;
		case BLINK:
		case CIRCLE:
		case RECTANGLE:
		case FILL:
		case TEXT:
			artist(c);
			break;
		case SAVE:
			if(betw(0, cur_color, 255)) {
				set_table(cur_color, cur_mix);
				hcopy(cur_mix, Colors[cur_color].HLS);
				Colors[cur_color].known = MIXED;
				dnumber(cur_color);
			}
			break;
		case WRITE:
			s = dfcn("file", YES);
			write_Col((s && *s) ? s : writefile);
			break;
		case QUIT:
			if(force_write)
				write_Col(writefile);
			cwrapup();
		}
	}
}

cwrapup()
{
	extern int Yellow[3];
	int i;

	if(started) {
		restore();
		for(i = 0; i < 20; i++)
			putchar(ESC);
		zoom(1,1);
		origin(0,482);
		derase();
		for(i = 128; i < 256; i++)
			if(Colors[i].known == NA)
				set_table(i, Yellow);
		w_mask(0);
		erase();
		r_mask(ALL);
		w_mask(ALPHA);
		user_sub(RESTORE_CAP);
		alpha(YES);
	}
	exit();
}
