#include <jerq.h>
#include <font.h>
#define RAD 3
#define TOPMAR 10

static char *items[] = {
	"Fix X",
	"Fix Y",
	"Exit",
	NULL
	};
static Menu menu = { items };

boxinteract(x,y,n,nxp,xlab,nyp,ylab)
short *x,*y,n,nxp,nyp;
char *xlab[], *ylab[];
{
	short *prevx,*prevy,*curx,*cury;
	char *prevxl,*prevyl,*curxl,*curyl,*disxl,*disyl;
	int i,j,ix,iy,fixedx = 0,fixedy = 0;
	Bitmap *ball; extern Bitmap *Slayer;
	Point here, mxspeed, myspeed, dxspeed, dyspeed;

	prevx = 0; prevy = 0;
	prevxl = 0; prevyl = 0;
	disxl = 0; disyl = 0;
	ball = balloc(Rect(0,0,RAD*2+1,RAD*2+1));
	rectf(ball, ball->rect, F_CLR);
	disc(ball,add(ball->rect.origin, Pt(RAD,RAD)), RAD,F_XOR);
/* 	disc(ball,add(ball->rect.origin, Pt(RAD,RAD)), RAD-1, F_XOR); */
	mxspeed.y = Slayer->rect.origin.y + TOPMAR;
	myspeed.y = dxspeed.y = dyspeed.y = mxspeed.y;
	i = Slayer->rect.corner.x - Slayer->rect.origin.x;
	mxspeed.x = Slayer->rect.origin.x + 2;
	myspeed.x = Slayer->rect.origin.x + i/4;
	dxspeed.x = Slayer->rect.origin.x + i/2;
	dyspeed.x = Slayer->rect.origin.x + 3*i/4;

	wait(MOUSE);
	for(;;){
		here = mouse.xy;
		if(fixedx==0){
			ix = muldiv(here.x-Slayer->rect.origin.x,nxp,
				Slayer->rect.corner.x-Slayer->rect.origin.x);
			ix = ix>=nxp? nxp-1: ix<0?0: ix;
			}
		if(fixedy==0){
			iy = muldiv(Slayer->rect.corner.y-here.y,nyp,
				Slayer->rect.corner.y-Slayer->rect.origin.y);
			iy = iy>=nyp? nyp-1: iy<0?0: iy;
			}
		curx = x+ix*n; cury = y+iy*n;
		curxl = xlab[ix]; curyl = ylab[iy];

		if(prevxl!=curxl || prevyl!=curyl){	/* update speedo if change */
			if(prevxl){
				string(&defont, prevxl, Slayer, mxspeed, F_XOR);
				string(&defont, prevyl, Slayer, myspeed, F_XOR);
				}
			string(&defont, curxl, Slayer, mxspeed, F_XOR);
			string(&defont, curyl, Slayer, myspeed, F_XOR);
			prevxl = curxl; prevyl = curyl;
			}

		if(button1()){
			for(i=0; i<n; i++){
				if(prevx)
					bitblt(ball,ball->rect,Slayer,
						Pt(*(prevx+i),*(prevy+i)),F_XOR);
				bitblt(ball,ball->rect,Slayer,
					Pt(*(curx+i),*(cury+i)),F_XOR);
				}
			if(disxl){
				string(&defont, disxl, Slayer, dxspeed, F_XOR);
				string(&defont, disyl, Slayer, dyspeed, F_XOR);
				}
			string(&defont, curxl, Slayer, dxspeed, F_XOR);
			string(&defont, curyl, Slayer, dyspeed, F_XOR);
			prevx = curx; prevy = cury;
			disxl = curxl; disyl = curyl;
			}
		if(button3()) {
			items[0] = fixedx? "Free X": "Fix X";
			items[1] = fixedy? "Free Y": "Fix Y";
			switch(menuhit( &menu, 3)){
			case 0: /* fix/free x */
				fixedx = 1 - fixedx;
				break;
			case 1: /* fix/free y */
				fixedy = 1 - fixedy;
				break;
			case 2: /* exit */
				bfree(ball);
				return;
				}
			}
		}
}
