INCLUDE(device,tty5620)
undefine(`SHOME')
#include <signal.h>
#include <stdio.h>
#include "/usr/jerq/include/jioctl.h"

static char
	buf[PACKET],		/* storage for a packet of data */
	*p = &buf[0]		/* free position in buf */
;
static int opened = 0;


extern float F77_COM(bgrp)[];			/* graphical parameters */
define(`am',`(F77_COM(bgrp)[($1)-1])')

int ask = 0;
int oldcol = 999, oldx = -9999, oldy = -9999;

F77_SUB(zparmz,real=par,int=n)
{
	r_zparmz(F_REALP(par),F_INTP(n));
}

static r_zparmz(par,n)
float par[]; long *n;
{
	char cmd[100];
	int i,mpx;
	for(i=1; i<=39; i++)
		am(i) = 0.0;
	am(20) = 9.;	/* char size in rasters */
	am(21) = 16.;
			/* am(22) - am(25) filled later */
	am(26) = 0.;	/* char addressing offset */
	am(27) = .75;
	am(28) = .01;	/* raster size in inches */
	am(29) = .01;
	am(30) = BLIT;
	am(31) = 1;	/* allow char rotation */
	am(1) = 1.;	/* allow char size change */

	mpx = ioctl(1,JMUX,0) != -1;
	if(!mpx) FATAL(The tty5620 driver only works under mux)

	if(*n>=1) ask = par[0];
	if(*n>=2 && par[1]>0){	/* load the driver */
		sprintf(cmd,"/usr/jerq/bin/32ld %s/cmd/Sterm.3",
			getenv("SHOME"));
		system(cmd);
		system("stty old!");
		}
	

	printf("Use button 3 to select graphic layer\n");
	echo_off();
	graphic(INIT); F77_CALL(zflshz);
	scanf("%f %f %f %f",& am(22),& am(24),& am(23),& am(25));
	while(getchar()!='\n');	/* skip newline */
	echo_on();
}

xysc(xa, ya)
int xa, ya;
{
	int yi;
	yi = (int) am(25) - ya + (int) am(24);
	graphic((xa&037) | 0100);
	graphic(((xa >> 5) & 037) | 0100);
	graphic((yi&037) | 0100);
	graphic(((yi >> 5) & 037) | 0100);
}

xyshort(xa, ya, op)
char op; int xa, ya;
{
	int xi,yi;
	if(abs(xa-oldx)>MAXREL || abs(ya-oldy)>MAXREL) return(0);
	xi = xa - oldx + MAXREL;
	yi = - (ya - oldy) + MAXREL;
	graphic(op);
	graphic((xi&077) | 0100);
	graphic((yi&077) | 0100);
	oldx = xa; oldy = ya;
	return(1);
}

static flush()
{
	write(1, &buf[0], p - &buf[0]);
	p = &buf[0];
}

graphic(c)
char c;
{
	if(!opened++) *p++ = GRAPH_BEGIN;
	*p++ = c;
	if (p == &buf[PACKET])
		flush();
}

F77_SUB(zlinez,int=ix,int=iy)
{
	r_zlinez(F_INTP(ix),F_INTP(iy));
}

static r_zlinez(ix,iy)
long int *ix,*iy;
{
	newcolor();
	if(xyshort((int)*ix,(int)*iy,RELLINE)) return;
	graphic(LINE);
	xysc((int) *ix, (int) *iy);
	oldx = *ix; oldy = *iy;
}

F77_SUB(zptchz,char=ich,real=crot)
{
	r_zptchz(F_CHARP(ich),F_REALP(crot));
}

static r_zptchz(ich,crot)
char *ich; float *crot;
{
	if(fabs(*crot)<45.) { 
		graphic(CHR);
		oldx += am(20);
		}
	else {
		graphic(RCHR);
		oldy += am(20);
		}
	graphic(*ich);
}

F77_SUB(zseekz,int=ix,int=iy)
{
	r_zseekz(F_INTP(ix),F_INTP(iy));
}

static r_zseekz(ix,iy)
long int *ix,*iy;
{
	newcolor();
	if(*ix==oldx && *iy==oldy) return;
	if(xyshort((int)*ix,(int)*iy,RELMOVE)) return;
	graphic(MOVE);
	xysc((int) *ix, (int) *iy);
	oldx = *ix; oldy = *iy;
}

F77_SUB(zejecz)
{
	extern long F77_COM(reshap);
	long x1,x2,y1,y2;
	if(ask){
		fprintf(stderr,"GO? ");
		while( getchar()!='\n' ) ;	/* ignore reply */
		}
	graphic(ERASE); F77_SUB(zflshz);

	echo_off();
	scanf("%ld %ld %ld %ld" ,&x1,&y1,&x2,&y2);
	while(getchar()!='\n');	/* skip newline */
	echo_on();
	if(x1!=am(22) || y1!=am(24) || x2!=am(23) || y2!=am(25)){
		oldx = oldy = -9999;
		F77_COM(reshap) = 1;
		F77_CALL(zzdevz,int=&x1,int=&x2,int=&y1,int=&y2);
		}
}


F77_SUB(zflshz)
{
	if(opened) { graphic(GRAPH_END); opened=0; }
	flush();
}

F77_SUB(zintrz)
{
	int i;
	if(opened) {
		for(i=0; i<10; i++)
			graphic(GRAPH_END);
		opened=0;
		}
	flush();
	oldx = oldy = -9999;
}

F77_SUB(zwrapz)
{ }

F77_SUB(zquxyz,int=x,int=y,int=flag)
{
	r_zquxyz(F_INTP(x),F_INTP(y),F_INTP(flag));
}

static r_zquxyz(x,y,flag)
long *x,*y,*flag;
{
	echo_off();
	graphic(QUERY); F77_SUB(zflshz);
	scanf("%ld %ld %ld",x,y,flag);
	while(getchar()!='\n');	/* eat newline */
	*y = (int)am(25) - *y + (int)am(24);
	if((*flag)>4) *flag = -1;
	echo_on();
}

newcolor(col)
int col;
{
	int which;
	which = (int)am(10);
	if(which==oldcol) return;
	graphic(COLOR);
	graphic(which + ' ');
	oldcol = which;
}

F77_SUB(zpolyz,real=x,real=y,int=n)
{
	r_zpolyz(F_REALP(x),F_REALP(y),F_INTP(n));
}

static r_zpolyz(x,y,n)
float x[],y[]; long *n;
{
	int i,which; long l1,l2; char *p;
	if(*n<3){
		F77_SUB(zflshz);
		F77_CALL(zerrpz,char="zpolyz",char="Needs at least 3 points");
		return;
		}
	newcolor();
	graphic(POLYGON);
	putout(*n);
	for(i=0; i<*n; i++){
		l1 = am(36)+am(37)*x[i];
		l2 = am(24)+am(25)-am(38)-am(39)*y[i];
		putout(l1); putout(l2);
		}
	F77_SUB(zflshz);
}

static putout(l)
long l;
{
	graphic((l & 037)|0100);
	graphic(((l>>5) & 037)|0100);
	graphic(((l>>10) & 077)|0100);
}
