FUNCTION boxplot(  range=/REAL,1,1./, plot=/LGL,1,TRUE/,  &)
STRUCTURE(p,p2,p3, psets/STR,10/)
STATIC( integer allout, m, leng, nbox, nout, nn; real c )
STATIC( POINTER junk, yenter )
LENGTH(VALUE(psets))=0
c=1.5*range

nbox=0
ALLARG(p,NOKEY)	# scan all args to find data vectors
	m=numode(P(p))
	if(m==STR) { # go down one level
		ARGSTR(p)
		ALLARG(p3)
			if(MODE(p3)!=NULL) COERCE(p3/REAL,NAOK/)
			NAOUT(`p3')
			nbox=nbox+1
			junk=yenter(P(psets),NOARG,P(p3))
		NEXTARG
		ARGSTR	# pop to regular instr
		}
	else {
		if(m!=NULL & m!=MISSING) {
			COERCE(p/REAL,NAOK/)
			NAOUT(`p')
			}
		nbox=nbox+1
		junk=yenter(P(psets),NOARG,P(p))
		}
	NAME(P(p)) = USED
NEXTARG

CHECK(nbox>0,FATAL(no data ))
STRUCTURE(
	stats		/MATRIX,5,nbox/
	n		/INT,nbox/
	ptrs		/INT,nbox/
	length		/INT,nbox/
	conf		/MATRIX,2,nbox/
	)
ARG(  names/CHAR,nbox/, &)

nbox=0
allout=0
ARGSTR(psets)
ALLARG(p)
	nbox = nbox + 1
	if(MODE(p)!=NULL) {
		COERCE( p/REAL/)
		leng=LENGTH(p); n[nbox]=leng
		if(MISSING(names)){
			names[nbox]=DATANAME(p)
			if(names[nbox]==SNULL) names[nbox]=NAME(P(p))
			}
		call bxstat(p,leng,nout,j,stats[1,nbox],conf[1,nbox],c)
		length[nbox] = nout
		ptrs[nbox] = j
		allout = allout + nout
		}
	else n[nbox]=0 # empty box
NEXTARG
ARGSTR

if(allout>0){
	STRUCTURE(
		out	/REAL,allout/
		group	/INT,allout/
		)
	nout=1
	for(i=1;i<=nbox;i=i+1){
		if(n[i]<=0)next
		nn=length[i]
		if(nn<=0) next
		j=ptrs[i]
		call rcopy(rs(j),out[nout],nn)
		call ifill(i,group[nout],nn)
		nout=nout+nn
		}
	}
RETURN(stats, n, conf, names,&)
if(allout>0)  RETURN(out, group,&)
if(plot){
	STRUCTURE(z/STR,1/)
	LENGTH(outstr) = nres
	VALUE(z)=outstr	# package results up into structure
	outstr=alcdir(5,fname,TFUN)	# new outstr
	nres=0; RETURN(z,FILTER,&)	# return Z and any other args
	CHAIN(bxp)
	}
END
