FUNCTION interp(
	x	/REAL/
	y	/REAL/
	z	/REAL/
	xo	/REAL,40/
	yo	/REAL,40/
	ncp	/INT,1,0/
	extrap	/LGL,1,FALSE/
	)
STATIC( logical miss )
n=LENGTH(x); nx=LENGTH(xo); ny=LENGTH(yo)
if(LENGTH(y)!=n | LENGTH(z)!=n)FATAL(Lengths of x y and z do not match)
if(MISSING(xo)){
	call rangev(x,n,xmin,xmax); dx=(xmax-xmin)/float(nx-1)
	for(i=0;i<nx;i=i+1) xo[i+1]=xmin+float(i)*dx
	}
if(MISSING(yo)){
	call rangev(y,n,ymin,ymay); dy=(ymay-ymin)/float(ny-1)
	for(i=0;i<ny;i=i+1) yo[i+1]=ymin+float(i)*dy
	}
STRUCTURE(
	zo	/MATRIX,nx,ny/
	iwk	/INT,max0(31,27+ncp)*n+nx*ny/
	wk	/REAL,5*n/
	)

miss=!extrap	#if not extrapolating use missing values
if(extrap & ncp==0)WARNING(cannot extrapolate with linear option)
call idsfft(1,ncp,n,x,y,z,nx,ny,xo,yo,zo,iwk,wk,miss)

RETURN(x=xo,y=yo,z=zo)
END
