# macro - expand macros with arguments
subroutine macro(evalst)
INCLUDE(macro,cmacro)

integer evalst(1)
integer gettok
integer defin(MAXDEF), t, token(MAXTOK)
integer lookup, push
integer ap, argstk(ARGSIZE), nlb, matchq
integer skipbl   #flag to ignore white space
integer balp(3)   #left & right parens + MACROEOS

call putc(INIT_PUTC)	# initialize output buffer
call unpakl(TSTRING(()),balp)	# string of balanced parens
depth = 0
cp = 0
ap = 1
ep = 1

for (t=gettok(token, MAXTOK, KEEP_WHITE); t != EOF; t=gettok(token, MAXTOK, skipbl)){
	skipbl = KEEP_WHITE
	if(t == QUESTION){ #cases: macro, literal or free-standing "?"
		t = gettok(token, MAXTOK, KEEP_WHITE)   #blanks significant after "?"
		if(t == ALPHA){ #possible macro name
			if(lookup(token, defin) == NO)
				call puttok(token, evalst)   #not defined
			else{ #defined- put it in Eval stack
				cp = cp + 1
				if(cp > CALLSIZE)
					FATAL(Macros nested too deeply)
				callst(cp) = ap; plev(cp) = 0
				ap = push(ep, argstk, ap)
				call putdef(defin, evalst)   #stack definition
				ap = push(ep, argstk, ap)
				call puttok(token, evalst)   #stack name
				call putchr(MACROEOS, evalst)
				ap = push(ep, argstk, ap)
				t = gettok(token, MAXTOK, SKIP_WHITE)   #peek at next
				if(t != LPAREN){ #add "()", no arguments to macro
					call pbstr(token)
					call pbstr(balp)
					numarg(cp) = 0
					}
				else{ #lparen found: are there any arguments?
					t = gettok(token, MAXTOK, SKIP_NL)
					if(t == RPAREN){ #case "()": no arguments
						numarg(cp) = 0
						call pbstr(balp)   #return the 2 parens
						}
					else{ #there is at least 1 argument
						numarg(cp) = 1
						call pbstr(token)
						token(1) = LPAREN
						token(2) = MACROEOS
						call pbstr(token)
						}
					}
				}
			}
		else if(t == LPAREN){ #case: ?(literal)
			nlb = 1
			repeat{
				t = gettok(token, MAXTOK, KEEP_WHITE)   #blanks significant in ?(literal)
				if(t == LPAREN)
					nlb = nlb + 1
				else if(t == RPAREN){
					nlb = nlb - 1
					if(nlb == 0) break   #parens are balanced
					}
				else if(t == EOF)
					FATAL(Unexpected end-of-file in literal string)
				call puttok(token, evalst)
				}
			next   #continue with tokens after rparen
			}
		else{ #free-standing "?"
			call pbstr(token)	# allow re-scan of next character
			call putchr(QUESTION, evalst)   #return it
			}
		}
	else if(t == SHARP){	# comment - don't macro process rest of line
		call putchr(SHARP, evalst)
		repeat{
			t = gettok(token, MAXTOK, KEEP_WHITE)
			call puttok(token, evalst)
			} until(t == M_NEWLINE | t == END_MACRO | t == EOF)
		}
	else if(t == END_MACRO) 	# keep track of end of text from macro expansion
		depth = depth - 1
	else if(t == DQUOTE | t == SQUOTE){ #handle "string"
		call puttok(token, evalst)   #preserve the quote
		matchq = t	# matching quote char
		repeat {
			t = gettok(token, MAXTOK, KEEP_WHITE)   #blanks significant in "literal"
			if(t == EOF)
				FATAL(Unexpected end to quoted string)
			call puttok(token, evalst)
			if(t == matchq) break #terminating quote found
			}
		}
	else if (cp == 0)   #not in a macro at all
		call puttok(token, evalst)
	else if (t == LPAREN | t == LBRACK){
		if (plev(cp) > 0)
			call puttok(token, evalst)
		plev(cp) = plev(cp) + 1
		}
	else if (t == RPAREN | t == RBRACK){
		if(plev(cp)<=0) FATAL(Too many right parens)
		plev(cp) = plev(cp) - 1
		if (plev(cp) > 0)
			call puttok(token, evalst)
		else {            # end of argument list
			call putchr(MACROEOS, evalst)
			call mEval(argstk, callst(cp), ap-1, evalst)
			ap = callst(cp)   # pop Eval stack
			ep = argstk(ap)
			cp = cp - 1
			}
		}
	else if (t == COMMA & plev(cp) == 1){ #new arg
		call putchr(MACROEOS, evalst)
		ap = push(ep, argstk, ap)
		numarg(cp) = numarg(cp) + 1   #increment count of args found
		skipbl = SKIP_NL   #ignore leading blanks after comma in arglist
		}
	else
		call puttok(token, evalst)   #just stack it
	}
if (cp != 0)
	FATAL(Unexpected end-of-file during macro expansion)
call putc(EOF)   #flush output buffer

return
end
