FUNCTION menu(
	items	/CHAR/
	actions	/CHAR,OPTIONAL/
	how	/INT,1,1/
	prompt	/CHAR,1,istrng("Which one? ",11)/
	force	/LGL,1,TRUE/
	return	/LGL,1,TRUE/
	&
	)

INCLUDE(lexio,attach,read)
STRUCTURE( ans/INT,1/, file/CHAR,1/ )
STATIC( integer plmenu,sattac,sdetac,outfd,n,i; POINTER xmktmp )

n = LENGTH(items)
if(!MISSING(actions))
	if(LENGTH(actions)!=n) FATAL(Numbers of actions and items differ)

switch(how){
case 1: ENDARGS
case 2,3,4: call zinitz
	ARG(PAR)
	}

switch(how){
case 1:	# printed display
	for(i=1; i<=n; i=i+1) PRINT(I(i,0)," - ",C(TEXT(items[i])))
	ans = 0	# no response yet
	while( ans < 1 || ans > n) { # read choice until satisfactory
		call setprm(STDIN,TEXT(prompt))
		FREAD(STDIN); AUTO_CHECK=FALSE; DECODE(I(ans))
		FIELD_ERROR=FALSE	# no error msgs for bad input
		if(!force) break	# allow user to make no choice?
		}
case 2: # graphically with plotted items
	ans = plmenu(items,n,1,force)
case 3: # graphically using existing items
	ans = plmenu(items,n,0,force)
case 4: # graphically plotting items then erasing them
	ans = plmenu(items,n,2,force)
	}

if(ans<1 || ans >n) ans = 0		# if force==F and user made no choice
if(MISSING(actions)) RETURN(ans)	# if no actions, return number

if(ans>0){
	file=xmktmp(0)	# temp file for action
	outfd=sattac(TEXT(file),WRITE,SOURCE)	# put action on file
	FPRINT(outfd,C(TEXT(actions[ans])))
	outfd=sdetac(outfd)
	#get rid of previous diversion file if no return
	if((!return) & divers!=STDIN) divers=sdetac(divers)
	divers=sattac(TEXT(file),READ,SOURCE)	# attach as source file
	call xunlnk(TEXT(file))
	}
END
