ROUTINE(pltfit,		coordinates for drawing two-way plot of fit)
subroutine pltfit(row,nr,col,nc,grand,w,resid,ndim,c,xy,nxy,nline,ngrid)
real row(nr),col(nc),grand,xy(nxy,4),resid(ndim,1)

define(`NEXTLINE',`nline=nline+1
xy(nline,1)=$1
xy(nline,2)=$2
xy(nline,3)=$3
xy(nline,4)=$4
')

call narang(row,nr,rmin,rmax)
call narang(col,nc,cmin,cmax)
nline=0
x1=rmin; x2=rmax
for(i=1;i<=nc;i=i+1){
	if(NA(col(i)))next
	y1=col(i)*(1.+w*rmin)
	y2=col(i)*(1.+w*rmax)
	NEXTLINE(x1-y1,x2-y2,x1+y1+grand,x2+y2+grand)
	}
for(i=1;i<=nr;i=i+1){
	if(NA(row(i))) next
	x1=row(i); x2=x1
	y1=cmin*(1.+w*x1)
	y2=cmax*(1.+w*x2)
	NEXTLINE(x1-y1,x2-y2,x1+y1+grand,x2+y2+grand)
	}
ngrid=nline
if(c>=0.)
	for(i=1;i<=nr;i=i+1)
		for(j=1;j<=nc;j=j+1){
			if(NA(resid(i,j))) next
			adjres = resid(i,j)-w*row(i)*col(j)	# residual adjusted for interaction term
			if(abs(adjres)>c){
				x1=row(i)
				y1=col(j)*(1.+w*x1)
				NEXTLINE(x1-y1,x1-y1,x1+y1+grand,x1+y1+grand+adjres)
				}
			}
return
end
