ROUTINE(qtile, find quantiles of a set of data using partial sort)
subroutine qtile(x,n,qu,pr,npr,ipos)
integer n,npr,ipos(1)
real x(n),qu(npr),pr(npr)

integer nipos,i,j,j1,j2
real f

# first - find order statistics necessary for determining quantiles
nipos=0
for(i=1; i<=npr; i=i+1){
	order = n*pr(i)+.5
	nipos=nipos+1
	ipos(nipos)=amax1(order,1.)
	nipos=nipos+1
	ipos(nipos)=amin1(order+1.,float(n))
	}

call sorti(ipos,nipos)	# sort order stats desired

j=1
for(i=2; i<=nipos; i=i+1)	# compress out duplicates
	if(ipos(i)!=ipos(j)){
		j=j+1
		ipos(j)=ipos(i)
		}

call psort(x,n,ipos,j)

for(i=1; i<=npr; i=i+1){	# compute quantiles
	order = n*pr(i)+.5
	j1 = amax1(order,1.)
	j2 = amin1(order+1.,float(n))
	f=amod(order,1.)
	qu(i) = (1.-f)*x(j1)+f*x(j2)
	}

return
end
