# density of uniform distribution
real function dunif(x,a,b)
real x,a,b
return(1./(b-a))
end

# density of normal distribution
real function dnorm(x,mu,sigma)
real x, mu, sigma
return( exp(-.5*(x-mu)**2/sigma**2) / sqrt(2.*PI*sigma**2) )
end

# density of chi-square distribution
real function dchis(x,df)
real x, df
real df2,lden,alngam
df2=df/2.
lden = alog(x)*(df2-1.)-x/2.-alngam(df2)-df2*alog(2.)
return( exp(lden) )
end

# density of beta distribution
real function dbeta(x,a,b)
real x,a,b
real lden,alngam
lden = alngam(a+b) + (a-1.)*alog(x) + (b-1.)*alog(1.-x) -alngam(a)-alngam(b)
return( exp(lden) )
end

# density of F distribution
real function dfdis(x,num,denom)
real x,num,denom
real lden,alngam
lden = alngam((num+denom)/2.)+num/2.*alog(num/denom)+(num/2.-1.)*alog(x) -
	alngam(num/2.) - alngam(denom/2.) - (num+denom)/2.*alog(1.+x*num/denom)
return( exp(lden) )
end

# density of gamma distribution
real function dgamm(x,a)
real x,a
real lden,alngam
lden = (a-1.)*alog(x)-x-alngam(a)
return( exp(lden) )
end

# density of logistic
real function dlogi(x,mu,sigma)
real x, mu, sigma
real xnorm
xnorm = (x-mu)/sigma
return( exp(-xnorm)/sigma/(1.+exp(-xnorm))**2 )
end

# density of log normal
real function dlnor(x,mu,sigma)
real x, mu, sigma
return( exp(-.5*(alog(x)-mu)**2/sigma**2) / sqrt(2.*PI*sigma**2*x**2) )
end

# density of t distribution
real function dtdis(x,df)
real x, df
real lden,alngam
lden = alngam((df+1.)/2.)-((df+1.)/2.)*alog(1.+x**2/df)-
	alngam(df/2.)-.5*alog(PI*df)
return( exp(lden) )
end

# density of cauchy distribution
real function dcauc(x,mu,sigma)
real x,mu,sigma
return( 1./((sigma*PI)*(1.+((x-mu)/sigma)**2)) )
end
