#dstcld		compute density for probability distns
subroutine dstcld(x,n,par1,npar1,par2,npar2,whichf,naflag)
real x(1); integer n,whichf,npar1,npar2; logical naflag; POINTER par1,par2
# x: vector of quantiles, densities to be overwritten into it
# n: length of x
# par1,par2: value pointers for parameters of dist., checked by dstpar
# npar1,npar2: length of parameter vectors
# whichf: code for distribution
# naflag: flag set to TRUE iff NA's were generated from range checks

INCLUDE(struct, dist)
external dnorm,dlogi,dlnor,dfdis,dtdis,dbeta,dgamm,dcauc,dchis,dunif

PAR1=par1; PAR2=par2; NPAR1=npar1; NPAR2=npar2; NVALUES=n; WHICH=whichf #move values to common
switch(whichf) {
case NORM_DIST: call dstcd1(x,dnorm)
case LOGIS_DIST: call dstcd1(x,dlogi)
case LNORM_DIST: call dstcd1(x,dlnor)
case F_DIST: call dstcd1(x,dfdis)
case T_DIST: call dstcd1(x,dtdis)
case BETA_DIST: call dstcd1(x,dbeta)
case CAUCHY_DIST: call dstcd1(x,dcauc)
case GAMMA_DIST: call dstcd1(x,dgamm)
case CHISQ_DIST: call dstcd1(x,dchis)
case UNIF_DIST: call dstcd1(x,dunif)
default: FATAL(Unavailable probability distribution)
	}
naflag=NAFLAG
return
end

#dstcd1		inner layer of dstclp, using common block, supplied function
subroutine dstcd1(x,prfun)
real x(1),prfun
external prfun

INCLUDE(stack, struct, dist)
define(`NA_ACTION',`{x(i)=0.; next}')
integer i
NAFLAG=FALSE; i1=0; i2=0
for(i=1; i<=NVALUES; i=i+1) {
	if(NA(x(i),REAL))next
	switch(WHICH/10) { # switch on type of distribution
	case NORMAL_TYPE: x(i)=prfun(x(i),rs(PAR1+i1),rs(PAR2+i2)) # no range check, 2 pars
	case F_TYPE: switch( WHICH ) { # range check, 1 par.
		case F_DIST: if(x(i)<0.)NA_ACTION
		case BETA_DIST: if(x(i)<0. | x(i)>1.)NA_ACTION
			}
		x(i)=prfun(x(i),rs(PAR1+i1),rs(PAR2+i2))
	case CHISQ_TYPE: if(x(i)<0.)NA_ACTION
		x(i)=prfun(x(i),rs(PAR1+i1)) # >=0, 1 parameter
	case T_TYPE: x(i)=prfun(x(i),rs(PAR1+i1)) #no check, 1 par.
	case UNIF_TYPE: if(x(i)<rs(PAR1+i1) | x(i)>rs(PAR2+i2))NA_ACTION
		x(i)=prfun(x(i),rs(PAR1+i1),rs(PAR2+i2))
		}
	i1=i1+1; if(i1==NPAR1)i1=0; i2=i2+1; if(i2==NPAR2)i2=0
	}
return
end
