subroutine wandrw(n,u,scale,const,sqw)
integer n
real u(n),const,sqw(n),scale
integer i
real c1,rktol,u1
real abs,sin,sqrt
rktol=sqrt(PRECISION)
c1 = const*sqrt(12.0)
do i = 1,n {
	ui = u(i)/scale
	u1 = abs(ui)
	if (u1>PI*const)
		sqw(i) = 0.0
	else if (u1<SMALL*c1)
		sqw(i) = 1.0
	else {
		u1 = ui/c1
		if (abs(u1)<=rktol)
			sqw(i) = (0.5+u1+0.5)*(0.5-u1+0.5)
		else {
			u1 = ui/const
			sqw(i) = sqrt(sin(u1)/u1)
			}
		}
	}
return
end



subroutine wbiwgt(n,u,scale,const,sqw)
integer n
real u(n),const,sqw(n),scale
integer i
real u1
real abs
do i = 1,n {
	ui = u(i)/scale
	u1 = abs(ui)
	if (u1>const)
		sqw(i) = 0.0
	else {
		if (const<=1.0)
			if (u1>BIG*const) {
				sqw(i) = 0.0
				next 1
				}
		if (u1<SMALL*const)
			sqw(i) = 1.0
		else {
			u1 = ui/const
			sqw(i) = (0.5+u1+0.5)*(0.5-u1+0.5)
			}
		}
	}
return
end



subroutine wcauch(n,u,scale,const,sqw)
integer n
real u(n),const,sqw(n),scale
integer i
real c1,rktol,sqinf1,u1
real abs,sqrt
sqinf1 = sqrt(BIG)
rktol=sqrt(PRECISION)
c1 = const*sqrt(2.0)
do i = 1,n {
	ui = u(i)/scale
	u1 = abs(ui)
	if (c1<=1.0)
		if (u1>BIG*c1) {
			sqw(i) = 0.0
			next 1
			}
	if (u1<SMALL*c1)
		sqw(i) = 1.0
	else {
		u1 = ui/c1
		if (abs(u1)<=rktol)
			sqw(i) = (0.5+u1+0.5)*(0.5-u1+0.5)
		else {
			u1 = abs(ui/const)
			if (u1<sqinf1)
				sqw(i) = 1.0/sqrt(0.5+u1*u1+0.5)
			else {
				sqw(i) = 0.0
				if (u1<=BIG)
					sqw(i) = 1.0/u1
				}
			}
		}
	}
return
end



subroutine  welsch(n,u,scale,const,sqw)
integer n
real u(n),const,sqw(n),scale
integer i
real c1,rktol,sqmexe,u1
real abs,exp,sqrt
rktol=sqrt(PRECISION)
sqmexe = sqrt(float(BIGEXP))
c1 = const*2.0
do i = 1,n {
	ui = u(i)/scale
	u1 = abs(ui)
	if (c1<=1.0)
		if (u1>BIG*c1) {
			sqw(i) = 0.0
			next 1
			}
	if (u1<SMALL*c1)
		sqw(i) = 1.0
	else {
		u1 = ui/c1
		if (abs(u1)<=rktol)
			sqw(i) = (0.5+u1+0.5)*(0.5-u1+0.5)
		else if (abs(u1)<=sqmexe)
			sqw(i) = exp(-u1*u1)
		else
			sqw(i) = 0.0
		}
	}
return
end



subroutine wfair(n,u,scale,const,sqw)
integer n
real u(n),const,sqw(n),scale
integer i
real u1
real abs
do i = 1,n {
	ui = u(i)/scale
	u1 = abs(ui)
	if (const<=1.0)
		if (u1>BIG*const) {
			sqw(i) = 0.0
			next 1
			}
	if (u1>=SMALL*const)
		sqw(i) = 1.0/(0.5+u1/const+0.5)
	else
		sqw(i) = 1.0
	}
return
end



subroutine whuber(n,u,scale,const,sqw)
integer n
real u(n),const,sqw(n),scale
integer i
real sqh,squ
real abs,sqrt
sqh = sqrt(const)
do i = 1,n {
	ui = u(i)/scale
	squ = abs(ui)
	if (squ<=const)
		sqw(i) = 1.0
	else {
		squ = sqrt(squ)
		if (sqh>=squ*SMALL)
			sqw(i) = sqh/squ
		else
			sqw(i) = 0.0
		}
	}
return
end



subroutine wlogis(n,u,scale,const,sqw)
integer n
real u(n),scale,const,sqw(n)
integer i
real c1,rktol,u1
real abs,sqrt,tanh
rktol=sqrt(PRECISION)
c1 = const*sqrt(6.0)
do i = 1,n {
	ui = u(i)/scale
	u1 = abs(ui)
	if (c1<=1.0)
		if (u1>BIG*c1) {
			sqw(i) = 0.0
			next 1
			}
	if (u1<SMALL*c1)
		sqw(i) = 1.0
	else {
		u1 = ui/c1
		if (abs(u1)<=rktol)
			sqw(i) = (0.5+u1+0.5)*(0.5-u1+0.5)
		else {
			u1 = ui/const
			sqw(i) = sqrt(tanh(u1)/u1)
			}
		}
	}
return
end



subroutine wtalwr(n,u,scale,const,sqw)
integer n
real u(n),const,sqw(n),scale
integer i
real u1
real abs
do i = 1,n {
	ui = u(i)/scale
	u1 = abs(ui)
	if (u1>const)
		sqw(i) = 0.0
	else
		sqw(i) = 1.0
	}
return
end



