#cday     cday - get matrix of frequency of days
subroutine cday(imonth,iyear,lmonth,lyear,ieast,hol,powout,days,nmax)
real holday(7),hol(1),days(nmax,1),avgm(1)
integer month(12)
#
#  1=new years
#  2=wash. birth.
#  3=memorial day
#  4=july 4th
#  5=columbus day
#  6=veterans day
#  7=christmas
#  2nd dimension of days nis (7+ieast)
#
#  sabl error flag
common/errcm/ierr
#
data month(1),month(2),month(3),month(4),month(5),month(6),month(7),month(8),month(9),month(10),month(11),month(12)/3,1,
  3,2,3,2,3,3,2,3,2,3/
#
zero = zrol(zl)
#
#  check argument values
imo = imonth
lmo = lmonth
if (imonth<=0||imonth>12)
	imo = 1
if (lmonth<=0||lmonth>12)
	lmo = 12
nn = (lyear-iyear)*12+(lmo-imo+1)
if (nn<=0) {
#
#  error
	ierr = 2
	ierrno = 108
	call ewrt(ierrno)
	}
else {
	jeast = ieast
	if (jeast!=1)
		jeast = 0
	if (jeast>0)
		if (iyear<=1582||lyear>=5000) {
			ierr = 2
			ierrno = 109
			call ewrt(ierrno)
			return
			}
#
#  set defaults for holidays if hol(1)<0
	call rmovf(hol,7,holday)
	if (holday(1)<0.0) {
		holday(1) = 1.
		holday(2) = 0.
		holday(3) = 1.
		holday(4) = 1.
		holday(5) = 0.
		holday(6) = 0.
		holday(7) = 1.
		}
#
	je7 = jeast+7
	avgm(1) = 30.4375
	powio = powout
	call ptr(avgm(1),1,powio,avgm(1))
	if (ierr==3)
		ierr = 2
	if (ierr==2)
		continue
	else {
		call brput(4.,days,nmax*7)
		if (jeast!=0)
			call brput(0.,days(1,8),(nmax))
		idow = mdow(iyear,imo,1)
		inpt = 0
		iymo = 0
		im = imo
		lm = 12
#
		do iy00 = iyear,lyear {
			if (iy00==lyear)
				lm = lmo
			month(2) = mleap((iy00))
			do i = im,lm {
				inpt = inpt+1
				if (month(i)!=0) {
					monthi = month(i)
					do j = 1,monthi {
						days(inpt,idow) = 5.
						idow = idow+1
						if (idow==8)
							idow = 1
						}
					}
				}
#
#  new year
			if (holday(1)>zero&&im<=1) {
				idh = mdow((iy00),1,1)
				iymo1 = iymo+1
				days(iymo1,idh) = days(iymo1,idh)-holday(1)
				}
#  washingtons birthday
			if (holday(2)>zero&&im<=2) {
				if (lm<2)
					go to 10
				idh = 1
				if (iy00<1971)
					idh = mdow((iy00),2,22)
				iymo1 = iymo+3-im
				days(iymo1,idh) = days(iymo1,idh)-holday(2)
				}
#  easter
			if (jeast!=0) {
				call meast((iy00),i,idh)
				if (i>=im&&i<=lm) {
					iymo1 = iymo+i-im+1
					days(iymo1,7) = days(iymo1,7)-1.
					days(iymo1,8) = 1.
					}
				}
#  memorial day
			if (holday(3)>zero&&im<=5) {
				if (lm<5)
					go to 10
				idh = 1
				if (iy00<1971)
					idh = mdow((iy00),5,30)
				iymo1 = iymo+6-im
				days(iymo1,idh) = days(iymo1,idh)-holday(3)
				}
#  july 4th
			if (holday(4)>zero&&im<=7) {
				if (lm<7)
					go to 10
				idh = mdow((iy00),7,4)
				iymo1 = iymo+8-im
				days(iymo1,idh) = days(iymo1,idh)-holday(4)
				}
#  columbus day
			if (holday(5)>zero&&im<=10) {
				if (lm<10)
					go to 10
				idh = 1
				if (iy00<1971)
					idh = mdow((iy00),10,12)
				iymo1 = iymo+11-im
				days(iymo1,idh) = days(iymo1,idh)-holday(5)
				}
#  veterans day
			if (holday(6)>zero)
				if (iy00>=1971&&iy00<1978) {
#        monday years (71-77)
					if (im<=10) {
						if (lm<10)
							go to 10
						iymo1 = iymo+11-im
						days(iymo1,1) = days(iymo1,1)-holday(6)
						}
					}
				else
#        non-monday years
				 if (im!=12) {
					if (lm<11)
						go to 10
					idh = mdow((iy00),11,11)
					iymo1 = iymo+12-im
					days(iymo1,idh) = days(iymo1,idh)-holday(6)
					}
#  christmas
			if (holday(7)>zero&&lm>=12) {
				idh = mdow((iy00),12,25)
				iymo1 = iymo+13-im
				days(iymo1,idh) = days(iymo1,idh)-holday(7)
				}
#
#  month length adjust series
			10  do i = im,lm {
				fac = month(i)
				fac = (28.+fac)/avgm(1)
				iymo = iymo+1
				do j = 1,je7
					days(iymo,j) = days(iymo,j)/fac
				}
#
			im = 1
			}
		}
	}
return
end



