#cmp      cmp - decomposition matching dcom, on days matrix
subroutine cmp(x,ee,wt,n,ntre,nsea)
real x(1),wt(1),ee(1)
#
#  sabl error flag
common/errcm/ierr
#
#  dynamic core storage
INCLUDE(stack)
#
#  set parameter value
data npc/12/
#
#  check argument values
nts = ntre
nss = nsea
if (ntre<=2)   nts = 11
if (nsea<=2)   nss = 15
#
#  ensure odd- length smoothers
nt = 2*((nts-1)/2)+1
ns = 2*((nss-1)/2)+1
ntr = 2*nt+1
nsr = 2*ns+1
#
#  get work space.  ii,jj=nyr, ir=(nyr+1), (ii+jj+ir)=n
n24 = n+2*npc
ir = (n/npc)+1
ir1 = n24+nt+ns+ntr+nsr+n*2+ir
ir2 = jstkgt(ir1,3)
ibt = ir2+n24
ibs = ibt+nt
itr = ibs+ns
isr = itr+ntr
ii = isr+nsr
iv = ii+n
iw = iv+n
jj = ii+ir
ir = jj+ir
ir1 = ir+1
#
#  get trend, seasonal, robustness weights
call biswt(nt,rs(ibt))
call biswt(ns,rs(ibs))
call biswt(nsr,rs(isr))
call biswt(ntr,rs(itr))
#
#  compute absolute irregular
call absv(ee,n,rs(iv))
#
#  seasonal smooth with robustness weights.  gains 2*npc
do k = 1,npc {
	call seaot(wt,(n),(k),(npc),rs(iw),l)
	call seaot(rs(iv),(n),(k),(npc),rs(jj),l)
	call drwt(rs(jj),l,nsr,rs(isr),rs(ii))
	if (ierr==2)  goto 60
	call seaot(x,(n),(k),(npc),rs(jj),l)
	call dwls(rs(jj),l,ns,rs(ibs),1,l,1,rs(ii),rs(iw),1,rs(ir1))
	if (ierr==2)  goto 60
	lp1 = l+1
	lp2 = l+2
	lp3 = lp1+ir
	call dwls(rs(ir1),l,ns,rs(ibs),lp1,lp1,0,wt,wt,1,rs(lp3))
	if (ierr==2)  goto 60
	call dwls(rs(ir1),l,ns,rs(ibs),0,0,0,wt,wt,1,rs(ir))
	if (ierr==2)  goto 60
	call seain(rs(ir),lp2,(k),(npc),rs(ir2))
	}
lp1 = ir2+npc
call subt(x,rs(lp1),n,x)
#
#  smooth extended seasonal to remove trend.  loses 2*npc
call dma(rs(ir2),n24,npc,rs(ir2))
n24 = n24-npc+1
call dma(rs(ir2),n24,2,rs(ir2))
n24 = n24-1
call dwls(rs(ir2),n24,nt,rs(ibt),7,n24-6,0,wt,wt,1,rs(ii))
if (ierr==2) goto 60
call add(x,rs(ii),(n),x)
#
#  robustness weights for each period
do k = 1,npc {
	call seaot(rs(iv),(n),(k),(npc),rs(ir2),l)
	call drwt(rs(ir2),l,ntr,rs(itr),rs(iw))
	if (ierr==2) goto 60
	call seain(rs(iw),l,(k),(npc),rs(ii))
	}
#
#  trend smooth with robustness weights
call dwls(x,(n),nt,rs(ibt),1,(n),1,wt,rs(ii),1,rs(ir2))
if (ierr==2) goto 60
call subt(x,rs(ir2),(n),x)
call dwls(x,(n),nt,rs(ibt),1,(n),1,wt,rs(ii),1,rs(ir2))
if (ierr==2) goto 60
ir2 = ir2+6
call subt(x(7),rs(ir2),n-12,x)
#
#  release work space
60  call jstkrl(1)
return
end
