#dcom     dcom - seasonal decomposition with robustness weights extended
subroutine dcom(xc,nn,ncyc,ntre,nsea,nsteps,tt,ss,ee,wt)
#
real xc(1),tt(1),ss(1),ee(1),wt(1)
logical leven
#
#  sabl error flag
common/errcm/ierr
#
#  dynamic core storage
INCLUDE(stack)
#
#  check argument values
npc = ncyc
nts = ntre
nss = nsea
if (ncyc<=1)  npc = 12
if (ntre<=2)  nts = 11
if (nsea<=2)  nss = 15
n = nn
if (n<npc*3) call ewrt(120)
iter = 2
if (nsteps>0) iter = nsteps
#
#  initialize
npc2 = npc*2
npcm = npc-1
jj = n/2+1
k = 2*(npc/2)
leven = k==npc
#
#  ensure odd- length smoothers
nt = 2*((nts-1)/2)+1
if (nt!=nts) call ewrt(32)
ns = 2*((nss-1)/2)+1
if (ns!=nss) call ewrt(34)
ntr = 2*nt+1
nsr = 2*ns+1
#
#  get work space
nv = (n/npc)+1
k = nt+ns+ntr+nsr+2*n+npc2+nv
ibt = jstkgt(k,3)
ibs = ibt+nt
itr = ibs+ns
isr = itr+ntr
ii = isr+nsr
iv = ii+n+npc2
iw = iv+n
#
#  get bisquare weights
call biswt(nt,rs(ibt))
call biswt(ns,rs(ibs))
call biswt(ntr,rs(itr))
call biswt(nsr,rs(isr))
#
#  initial trend smooth.  loses 2*npc
call dmm(xc,n,npc,ss)
if (ierr==2) goto 60
nv = n-npcm
call dma(ss,nv,npc,ss)
nv = nv-npcm
call dma(ss,nv,3,tt)
nv = nv-2
#
#  first seasonal smooth.  regains 2*npc
k = npc+1
call subt(xc(k),tt,nv,rs(ii))
do k = 1,npc {
	kk = k
	call seaot(rs(ii),nv,kk,(npc),tt,l)
	call dwmm(tt,l,ns,rs(ibs),1,ee)
	if (ierr==2)  goto 60
	call dwls(ee,l,ns,rs(ibs),1,l,0,wt,wt,1,tt(2))
	if (ierr==2)  goto 60
	lp1 = l+1
	lp2 = l+2
	call dwls(tt(2),l,ns,rs(ibs),0,0,0,wt,wt,1,tt(1))
	if (ierr==2)  goto 60
	call dwls(tt(2),l,ns,rs(ibs),lp1,lp1,0,wt,wt,1,tt(lp2))
	if (ierr==2)  goto 60
	call seain(tt,lp2,kk,(npc),ss)
	}
#
#  first trend smooth
call subt(xc,ss,n,ee)
call dwmm(ee,n,nt,rs(ibt),1,ss)
if (ierr==2) goto 60
call dwls(ss,n,nt,rs(ibt),1,n,0,wt,wt,1,tt)
if (ierr==2) goto 60
#  twicing
call subt(ee,tt,n,ss)
call dwmm(ss,n,nt,rs(ibt),1,rs(ii))
if (ierr==2) goto 60
call dwls(rs(ii),n,nt,rs(ibt),1,n,0,wt,wt,1,ss)
if (ierr==2) goto 60
call add(tt,ss,n,tt)
#
#  get trend irregular
call subt(ee,tt,n,ee)
#
#  iterate
do kstep = 1,iter {
#
#  compute absolute irregular
	call absv(ee,n,wt)
#
#  get full series weights
	call drwt(wt,n,nsr,rs(isr),rs(iv))
#
#  seasonal smooth, predicting at each end.  gains 2*npc
	call subt(xc,tt,n,tt)
	do k = 1,npc {
		kk = k
		call seaot(rs(iv),n,kk,(npc),rs(iw),l)
		call seaot(wt,n,kk,(npc),ss(jj),l)
		call drwt(ss(jj),l,nsr,rs(isr),ss)
		if (ierr==2) goto 60
		call seaot(tt,n,kk,(npc),ss(jj),l)
		call dwls(ss(jj),l,ns,rs(ibs),1,l,1,ss,rs(iw),1,ee(2))
		if (ierr==2) goto 60
		lp1 = l+1
		lp2 = l+2
		call dwls(ee(2),l,ns,rs(ibs),lp1,lp1,0,wt,wt,1,ee(lp2))
		if (ierr==2) goto 60
		call dwls(ee(2),l,ns,rs(ibs),0,0,0,wt,wt,1,ee(1))
		if (ierr==2) goto 60
		call seain(ee,lp2,kk,(npc),rs(ii))
		}
	k = ii+npc
	call rmovf(rs(k),n,ss)
#
#  smooth extended seasonal, then interior to remove trend. loses 2*npc
	k = n+npc2
	call dma(rs(ii),k,npc,rs(ii))
	k = k-npcm
	if (leven) {
		call dma(rs(ii),k,2,rs(ii))
		k = k-1
		}
	lp1 = ((npc+1)/2)+1
	lp2 = k-lp1+1
	call dwls(rs(ii),k,nt,rs(ibt),lp1,lp2,0,wt,wt,1,ee)
	if (ierr==2) goto 60
	call subt(ss,ee,n,ss)
#
#  get seasonal irregular
	call subt(tt,ss,n,ee)
	call absv(ee,n,ee)
#
#  robust wts for each period
	do k = 1,npc {
		kk = k
		call seaot(ee,n,kk,(npc),wt(jj),l)
		call drwt(wt(jj),l,ntr,rs(itr),wt)
		if (ierr==2) goto 60
		call seain(wt,l,kk,(npc),rs(iv))
		}
#
#  compute robustness weights using seasonal irregular
	call drwt(ee,n,ntr,rs(itr),wt)
	if (ierr==2) goto 60
#
#  trend smooth
	call subt(xc,ss,n,ee)
	call dwls(ee,n,nt,rs(ibt),1,n,1,wt,rs(iv),1,tt)
	if (ierr==2) goto 60
#  twicing
	call subt(ee,tt,n,rs(ii))
	call dwls(rs(ii),n,nt,rs(ibt),1,n,1,wt,rs(iv),1,ee)
	if (ierr==2) goto 60
	call add(tt,ee,n,tt)
#
#  irregular
	call subt(xc,tt,n,ee)
	call subt(ee,ss,n,ee)
	}
#
#  release work space
60  call jstkrl(1)
return
end
