#prreg    prreg - power transform regression. return t statistic
#  return y sorted and winsorized, x sorted
subroutine prreg(x,y,n,tstat)
#
real x(1),y(1)
#
#  sabl error flag
common/errcm/ierr
#
#  dynamic core storage
INCLUDE(stack)
#
#
#  get work space
ib1 = jstkgt(n*2,3)
if (ierr!=2) {
	ib3 = jstkgt(n,2)
	if (ierr!=2) {
		ib2 = ib1+n
		ib1m = ib1-1
		ib2m = ib2-1
		ib3m = ib3-1
#
#  sort x, carrying y and indices
		call bsorti(x,n,is(ib3))
		call rmovf(y,n,rs(ib1))
		do i = 1,n {
			m = ib3m+i
			k = ib1m+is(m)
			y(i) = rs(k)
			}
#
#  release integer stack
		call jstkrl(1)
		if (ierr==2)
			go to 10
#
#  robust slice regression.  return predicted values
		call line9(x,y,n,rs(ib1))
		if (ierr!=2) {
#
#  get ordered residuals.
			call subt(y,rs(ib1),n,rs(ib2))
			call sort0(rs(ib2),n)
#
#  find first positive residual
			do i = 1,n {
				m = ib2m+i
				if (rs(m)>=0.)
					break 1
				}
#
#  3*median approximates 2 std dev
			k = m-ib2
			rp = xmed(rs(m),n-k)*3.0
			rn = xmed(rs(ib2),k)*3.0
#
#  change y to (fitted+3*s) if outlier
			do i = 1,n {
				k = ib1m+i
				ext = rs(k)
				res = y(i)-ext
				if (res>rp)
					y(i) = ext+rp
				if (res<rn)
					y(i) = ext+rn
				}
#
#  get least squares regression of bounded data
			call line(x,y,n,ext,res,rn)
#
#  get t statistic
			rp = rn*rn
			tstat = rn*sqrt(float(n-2)/(1.0-rp))
			}
		}
#
#  release working space
	call jstkrl(1)
	if (ierr!=2)
		return
	}
#
#  error
10  continue
return
end



