#define zero 0.

F77_SUB(spline,real=xval,real=yval,int=n,real=diag,real=r,
	real=konst,int=periodic,real=xlb,real=xub,int=ni,
	real=xout,real=yout,int=iout)
{
	r_spline(F_REALP(xval),F_REALP(yval),(int)*F_INTP(n),
		F_REALP(diag),F_REALP(r),*F_REALP(konst),(int)*F_INTP(periodic),
		*F_REALP(xlb),*F_REALP(xub),(int)*F_INTP(ni),
		F_REALP(xout),F_REALP(yout),F_INTP(iout));
}

static float
rhs(i,n,xval,yval)
int i,n; float xval[],yval[];
{
	int i_;
	double zz;
	i_ = i==n-1?0:i;
	zz = (yval[i]-yval[i-1])/(xval[i]-xval[i-1]);
	return(6*((yval[i_+1]-yval[i_])/(xval[i+1]-xval[i]) - zz));
}

static r_spline(xval,yval,n,diag,r,konst,periodic,xlb,xub,ni,xout,yout,nout)
float xval[],yval[],diag[],r[],konst,xout[],yout[],xlb,xub;
int ni,n,periodic; long *nout;
{

	float d,s,u,v,hi,hi1;
	float h;
	float D2yi,D2yi1,D2yn1,x0,x1,yy,a;
	int end;
	float corr;
	int i,j,m,iout = 0;
	*nout = 0;
	if(n<3) return;
	if(periodic) konst = 0;
	d = 1;
	r[0] = 0;
	s = periodic?-1:0;
	for(i=0;++i<n-!periodic;){	/* triangularize */
		hi = xval[i]-xval[i-1];
		hi1 = i==n-1?xval[1]-xval[0]:
			xval[i+1]-xval[i];
		if(hi1*hi<=0) return;
		u = i==1?zero:u-s*s/d;
		v = i==1?zero:v-s*r[i-1]/d;
		r[i] = rhs(i,n,xval,yval)-hi*r[i-1]/d;
		s = -hi*s/d;
		a = 2*(hi+hi1);
		if(i==1) a += konst*hi;
		if(i==n-2) a += konst*hi1;
		diag[i] = d = i==1? a:
		    a - hi*hi/d; 
	}
	D2yi = D2yn1 = 0;
	for(i=n-!periodic;--i>=0;){	/* back substitute */
		end = i==n-1;
		hi1 = end?xval[1]-xval[0]:
			xval[i+1]-xval[i];
		D2yi1 = D2yi;
		if(i>0){
			hi = xval[i]-xval[i-1];
			corr = end?2*s+u:zero;
			D2yi = (r[i]-hi1*D2yi1-s*D2yn1+end*v)/
				(diag[i]+corr);
			if(end) D2yn1 = D2yi;
			if(i>1){
				a = 2*(hi+hi1);
				if(i==1) a += konst*hi;
				if(i==n-2) a += konst*hi1;
				d = diag[i-1];
				s = -s*d/hi; 
			}
		}
		else D2yi = D2yn1;
		if(!periodic) {
			if(i==0) D2yi = konst*D2yi1;
			if(i==n-2) D2yi1 = konst*D2yi;
			}
		if(end) continue;
		m = hi1>0?ni:-ni;
		m = 1.001*m*hi1/(xub-xlb);
		if(m<=0) m = 1;
		h = hi1/m;
		for(j=m;j>0||i==0&&j==0;j--){	/* interpolate */
			x0 = (m-j)*h/hi1;
			x1 = j*h/hi1;
			yy = D2yi*(x0-x0*x0*x0)+D2yi1*(x1-x1*x1*x1);
			yy = yval[i]*x0+yval[i+1]*x1 -hi1*hi1*yy/6;
			xout[iout] = xval[i]+j*h;
			yout[iout++] = yy; 
		}
	}
	*nout = iout;
}


/* Spline fit technique
let x,y be vectors of abscissas and ordinates
    h   be vector of differences h[i]=x[i]-x[i-1]
    y"  be vector of 2nd derivs of approx function
If the points are numbered 0,1,2,...,n+1 then y" satisfies
(R W Hamming, Numerical Methods for Engineers and Scientists,
2nd Ed, p349ff)
	h[i]y"[i-1[]]+2(h[i]+h[i+1])y"[i]+h[i+1]y"[i+1]
	
	= 6[(y[i+1]-y[i])/h[i+1]-(y[i]-y[i-1])/h[i]]   i=1,2,...,n

where y"[0] = y"[n+1] = 0
This is a symmetric tridiagonal system of the form

	| a[1] h[2]                 |  |y"[1]|      |b[1]|
	| h[2] a[2] h[3]            |  |y"[2]|      |b[2]|
	|    h[3] a[3] h[4]         |  |y"[3]|  =   |b[3]|
	|               .           |  | .|           | .|
	|                  .        |  | .|           | .|
It can be triangularized into
	| d[1] h[2]               |  |y"[1]|      |r[1]|
	|    d[2] h[3]            |  |y"[2]|      |r[2]|
	|       d[3] h[4]         |  |y"[3]|  =   |r[3]|
	|              .          |  | .|         | .|
	|                 .       |  | .|         | .|
where
	d[1] = a[1]

	r[0] = 0

	d[i] = a[i] - h[i]^2/d[i-1]	1<i<=n

	r[i] = b[i] - h[i]r[i-1]/d[i-1i]	1<=i<=n

the back solution is
	y"[n] = r[n]/d[n]

	y"[i] = (r[i]-h[i+1]y"[i+1])/d[i]	1<=i<n

superficially, d[i] and r[i] don't have to be stored for they can be
recalculated backward by the formulas

	d[i-1] = h[i]^2/(a[i]-d[i])	1<i<=n

	r[i-1] = (b[i]-r[i])d[i-1]/h[i]	1<i<=n

unhappily it turns out that the recursion forward for d
is quite strongly geometrically convergent--and is wildly
unstable going backward.
There's similar trouble with r, so the intermediate
results must be kept.

Note that n-1 in the program below plays the role of n+1 in the theory

Other boundary conditions_________________________

The boundary conditions are easily generalized to handle

	y[0]" = ky[1]", y[n+1]"   = ky[n]"

for some constant k.  The above analysis was for k = 0;
k = 1 fits parabolas perfectly as well as stright lines;
k = 1/2 has been recommended as somehow pleasant.

All that is necessary is to add h[1] to a[1] and h[n+1] to a[n].


Periodic case_____________

To do this, add 1 more row and column thus

	| a[1] h[2]            h[1] |  |y[1]"|     |b[1]|
	| h[2] a[2] h[3]            |  |y[2]"|     |b[2]|
	|    h[3] a[4] h[4]         |  |y[3]"|     |b[3]|
	|                           |  | .|     =  | .|
	|                   .       |  | .|        | .|
	| h[1]            h[0] a[0] |  | .|        | .|

where h[0]== h[n+1]

The same diagonalization procedure works, except for
the effect of the 2 corner elements.  Let s[i] be the part
of the last element in the ith "diagonalized" row that
arises from the extra top corner element.

		s[1] = h[1]

		s[i] = -s[i-1]h[i]/d[i-1]	2<=i<=n+1

After "diagonalizing", the lower corner element remains.
Call t[i] the bottom element that appears in the ith colomn
as the bottom element to its left is eliminated

		t[1] = h[1]

		t[i] = -t[i-1]h[i]/d[i-1]

Evidently t[i] = s[i].
Elimination along the bottom row
introduces further corrections to the bottom right element
and to the last element of the right hand side.
Call these corrections u and v.

	u[1] = v[1] = 0

	u[i] = u[i-1]-s[i-1]*t[i-1]/d[i-1]

	v[i] = v[i-1]-r[i-1]*t[i-1]/d[i-1]	2<=i<=n+1

The back solution is now obtained as follows

	y"[n+1] = (r[n+1]+v[n+1])/(d[n+1]+s[n+1]+t[n+1]+u[n+1])

	y"[i] = (r[i]-h[i+1]*y[i+1]-s[i]*y[n+1])/d[i]	1<=i<=n

Interpolation in the interval x[i]<=x<=x[i+1] is by the formula

	y = y[i]x[+] + y[i+1]x[-] -(h^2[i+1]/6)[y"[i](x[+]-x[+]^3)+y"[i+1](x[-]-x[-]^3)]
where
	x[+] = x[i+1]-x

	x[-] = x-x[i]
*/
