#include "rotate.h"
#ifdef DMD630
#include <dmd.h>
#include <5620.h>
#else
#include <blit.h>
#endif
#include <font.h>

extern Bitmap *Slayer;
long previous = 0;

short allones[] = { ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0 };
Bitmap curs =
	{ (Word *)allones, 1, {{0,0}, {16, sizeof(allones)/sizeof(allones[0])}},(char *)0};

short dx[6],dy[6],dz[6];
Point dcenter;	/* center of dreibein */
short dsize,drmin,dcmin;	/* size and offset of dreibein */

rotate(x, y, z, n, srow, scol, rmin, cmin, axis, sign, log2theta, ptsize)
short x[], y[], z[], n, srow, scol, rmin, cmin, axis, sign, log2theta, ptsize;
{
	short i, *from, *to, exp, f, t, *px, *pz, *dfrom, *dto, square, dcurs;
	Point screen;
	static short oldsize;

	if(sign==0) return;
	square = srow<scol?srow:scol;
	exp = 1 + 2 * log2theta;

	switch(axis) {
	case X_TO_Y: from = x; to = y; dfrom = dx; dto = dy; break;
	case Y_TO_Z: from = y; to = z; dfrom = dy; dto = dz; break;
	case Z_TO_X: from = z; to = x; dfrom = dz; dto = dx; break;
	}

	if(previous)dodreibein(dx,dz);
	else dreisetup(cmin,rmin,scol,srow,square);
	for(i=0; i<6; i++){	/* transform dreibein */
		f = *dfrom;
		t = *dto;
		*dfrom++ = f - (f>>exp) - sign * (t >> log2theta);
		*dto++ = t - (t>>exp) + sign * (f >> log2theta);
		}
	dodreibein(dx,dz);

	for(i = 0; i < n; i++) {	/* move each point to new position */

		if(previous){	/* undo previous version of the point */
			screen.x = TRANSFORM(*x, square)+cmin;
			screen.y = square - TRANSFORM(*z, square)+rmin;
			dcurs = 1-TRANSFORM(*y,3);
			bitblt(&curs, Rect(0,0,oldsize+dcurs,oldsize+dcurs), Slayer, screen, F_XOR);
		}

		f = *from;
		t = *to;
		*from++ = f - (f>>exp) - sign * (t >> log2theta);
		*to++ = t - (t>>exp) + sign * (f >> log2theta);

		screen.x = TRANSFORM(*x++, square)+cmin;
		screen.y = square - TRANSFORM(*z++, square)+rmin;
		dcurs = 1-TRANSFORM(*y++,3);
		bitblt(&curs, Rect(0,0,ptsize+dcurs,ptsize+dcurs), Slayer, screen, F_XOR);
	}
	oldsize = ptsize;
	previous++;
}

dodreibein(x,y)
short *x, *y;
{
	short i; Point pt;
	static char *s[] = {"1", "2", "3"};
	for(i=0; i<3; i++){
		pt.x = dcmin + TRANSFORM(*x++,dsize);
		pt.y = drmin + dsize-TRANSFORM(*y++,dsize);
		segment( Slayer, dcenter, pt, F_XOR);
		}
	for(i=0; i<3; i++){
		pt.x = dcmin + TRANSFORM(*x++,dsize);
		pt.y = drmin + dsize - TRANSFORM(*y++,dsize);
		string(&defont, *(s+i), Slayer, pt, F_XOR);
		}
}

dreisetup(cmin,rmin,scol,srow,square)
short cmin,rmin,scol,srow,square;
{
	short i,mymin(),mymax();
	dsize = mymin(mymax(square>>3,abs(scol-srow)),square);
	drmin = rmin+srow-dsize; dcmin = cmin+scol-dsize;
	dcenter.x = dcmin + TRANSFORM(0,dsize);
	dcenter.y = drmin + dsize - TRANSFORM(0,dsize);
	for(i=0; i<6; i++) dx[i]=dy[i]=dz[i]=0;
	dx[0]=dy[1]=dz[2]= muldiv(85,MAXCOORD,100);
	dx[3]=dy[4]=dz[5]= muldiv(95,MAXCOORD,100);
}

short mymin(a,b)
short a,b;
{ return (a)>(b)?(b):(a); }

short mymax(a,b)
short a,b;
{ return (a)<(b)?(b):(a); }
