ROUTINE(gnarcz,	return coordinates of circular or elliptical arcs)
subroutine gnarcz(xc,yc,r,a1,a2,xx,yy,nseg)
real xc,yc,r,a1,a2,xx(1),yy(1); integer nseg
# on input, nseg is max number of segments to generate

INCLUDE(graphics)
data piby4/0.785398/
if (r<=0.) {nseg=0; return}
QUERY( rsz(rx,ry), smo(smo), uin(ux,uy), pin(pw,ph) )
scd = smo*amin1(rx,ry)
ri = amax1(ux,uy)*r
# heuristic - makes small circles more accurate
wgt = sqrt(amax1(0.1,ri/amin1(pw,ph)))
scd = wgt*scd
# 1-cos(dt/2) = scd/ri
# compute dt approximately by taylor series
dt = amax1(DEG2RD,amin1(piby4,4.*sqrt(scd/ri)))
if (a2<a1) dt = -dt
t1 = amin1(a1,a2)*DEG2RD
t2 = amax1(a1,a2)*DEG2RD
if(abs((t2-t1)/dt)>nseg) FATAL(not enough storage for arc segments)
tcur = a1*DEG2RD
nseg = 1
while(tcur<t2&tcur>=t1) {
	xx(nseg) = xc+r*cos(tcur)
	yy(nseg) = yc+r*sin(tcur)
	nseg = nseg+1
	tcur = tcur+dt
	}
xx(nseg) = xc+r*cos(t2)
yy(nseg) = yc+r*sin(t2)
return
end
