ROUTINE(persp,		3-dim perspective plot of matrix)
subroutine persp(zfcn,xref,yref,v1,v2,v3,mcols,nrows,iscx,iscy)
real zfcn(mcols,nrows)
INCLUDE(graphics,persp)
integer jrow(MAXROW,2),jvrow(MAXROW,2)
logical invis1,invis2

nsegs = 0	# initialize output segment buffer
vx = v1	# set up /vars/ common block for coord transformations
vy = v2
vz = v3
xpos = xref
ypos = yref
m = mcols
n = nrows
if(m>MAXROW | n>MAXROW) FATAL(Too large an input matrix)
d = sqrt(vx*vx+vy*vy+vz*vz)
dx = 2.*xpos/float(m-1)
dy = 2.*ypos/float(n-1)
c1 = d/sqrt(vx*vx+vy*vy)
c2 = c1/d
xmin = BIG
ymin = BIG
xmax = -BIG
ymax = -BIG
do j = 1,n
	do i = 1,m {
		call cordm(i,j,ix,iy,x,y,zfcn,0,m,n)
		xmin = amin1(xmin,x)
		xmax = amax1(xmax,x)
		ymin = amin1(ymin,y)
		ymax = amax1(ymax,y)
		}
xs = float(iscx-20)/(xmax-xmin)
ys = float(iscy-20)/(ymax-ymin)
xscale = amin1(xs,ys)
yscale = xscale
trans1 = .5*(float(iscx)-xscale*(xmax+xmin))
trans2 = .5*(float(iscy)-yscale*(ymax+ymin))	# end initialization of /vars/

jv = 2.+(vy+ypos)/dy	# index of the first horizontal grid line above vy
if (vy<(-ypos)) jv = 2
do i = 1,m {
	x = float(i-1)*dx-xpos
	if (vy<=(-ypos)) {
		z = zfcn(i,1)
		y = -ypos
		}
	else {
		y = vy
		jv1 = jv-1
		z1 = zfcn(i,jv1)
		z2 = zfcn(i,jv)
		dy1 = vy-float(jv1-1)*dy+ypos
		alpha = dy1/dy
		z = alpha*(z2-z1)+z1
		}
	d2 = d*d
	r = d2/(d2-(x*vx+y*vy+z*vz))
	ix = c2*r*(y*vx-x*vy)*xscale+trans1
	iy = c1*(vz+r*(z-vz))*yscale+trans2
	jvrow(i,1) = ix	# plotting coordinates of points along partition line
	jvrow(i,2) = iy
	}
SPECIFY( usr(1.,1.+iscx,0.,float(iscy)) )
# the domain r is partitioned by the line y=vy into two subrectangles, r1(top), and r2(bottom).
# if v is southwest of r there is no partition, and r coincides with r1.
do iter = 1,2 {
	call ifill(iscy,min,MASKSIZE)
	call ifill(0,max,MASKSIZE)
	if (iter==1) {	# draw leading edge of surface defined over r1
		ix1 = jvrow(1,1)
		iy1 = jvrow(1,2)
		do j1 = jv,n {
			call cordm(1,j1,ix2,iy2,xdum,ydum,zfcn,1,m,n)
			call isegs(ix1,iy1,ix2,iy2)
			call mask(ix1,iy1,ix2,iy2,TRUE)
			ix1 = ix2
			iy1 = iy2
			}
		ix1 = jvrow(1,1)
		iy1 = jvrow(1,2)
		do i = 2,m {
			ix2 = jvrow(i,1)
			iy2 = jvrow(i,2)
			if (vy<=(-ypos)) {
				call isegs(ix1,iy1,ix2,iy2)
				if (vy!=-ypos) call mask(ix1,iy1,ix2,iy2,TRUE)
				}
			jrow(i,1) = ix2	# initialize jrow
			jrow(i,2) = iy2
			ix1 = ix2
			iy1 = iy2
			}
		jbegin = jv
		jend = n
		}
	else {	# draw leading edges of surface defined over r2
		call icopy(jvrow(2,1),jrow(2,1),m-1)
		call icopy(jvrow(2,2),jrow(2,2),m-1)
		ix1 = jvrow(1,1)
		iy1 = jvrow(1,2)
		do j = 2,jv {
			j1 = jv-j+1
			call cordm(1,j1,ix2,iy2,xdum,ydum,zfcn,1,m,n)
			call isegs(ix1,iy1,ix2,iy2)
			call mask(ix1,iy1,ix2,iy2,TRUE)
			ix1 = ix2
			iy1 = iy2
			}
		jbegin = 1
		jend = jv-1
		}
	call icopy(max,min,MASKSIZE)

# draw rest of surface, first over r1, then over r2
	nlevel = m+jend-jbegin-1
	do level = 1,nlevel
		do jlevel = 1,level {
			if (iter==1) j = jv+level-jlevel
			else j = jv-(level+1-jlevel)
			if(j>n | j<1) next
			i = jlevel+1
			if(i>m) next
			if (i==2||j==1||j==n)
				call cordm(i-1,j,ixsave,iysave,xdum,ydum,zfcn,1,m,n)
			call cordm(i,j,ix1,iy1,xdum,ydum,zfcn,1,m,n)
			if (iter==1) dir = jrow(i,1)-ix1-3
			else dir = ix1-ixsave+3
			if (dir==0.) dir = 1.
			invis1 = iy1<max(ix1) & iy1>min(ix1)	# invisibility of p1=(ix1,iy1)
			do l = 1,2 {
				if (dir*(float(l)-1.5)<0) {
					ix2 = ixsave
					iy2 = iysave
					}
				else {
					ix2 = jrow(i,1)
					iy2 = jrow(i,2)
					}
				invis2 = iy2<max(ix2) & iy2>min(ix2)	# invisibility of p2=(ix2,iy2)
				if(!invis1 & !invis2){	# both visible
					call isegs(ix1,iy1,ix2,iy2)
					if (iy1<=min(ix1)) call mask(ix1,iy1,ix2,iy2,FALSE)
					if (iy1>=max(ix1)) call mask(ix1,iy1,ix2,iy2,TRUE)
					}
				else {	# one or the other invisible
					idx = ix2-ix1
					idy = iy2-iy1
					if (idx==0) {	# no change in x
						ix = ix1
						iy = iy1
						if (invis1) iy = iy2
						if (iy<=min(ix)) {
							call isegs(ix,min(ix),ix,iy)
							min(ix) = iy
							}
						else {
							call isegs(ix,max(ix),ix,iy)
							max(ix) = iy
							}
						}
					else {	# find middle point where visible
						if (invis2) {
							ixhide = ix2
							iyhide = iy2
							ixvis = ix1
							iyvis = iy1
							}
						else {
							ixhide = ix1
							iyhide = iy1
							ixvis = ix2
							iyvis = iy2
							}
						nsteps = iabs(idx)
						jsign = (ixvis-ixhide)/iabs(ixvis-ixhide)
						do k = 1,nsteps {
							ix = ixhide+(jsign*k)
							iy = iyhide+(jsign*k*idy)/idx
							if (iy>=max(ix)){
								slope = iabs((max(ixhide)-max(ix))/k)
								if (slope>5.) max(ix) = iy
								call isegs(ixvis,iyvis,ix,max(ix))
								call mask(ixvis,iyvis,ix,max(ix),TRUE)
								break
								}
							if (iy<=min(ix)){
								slope = iabs((min(ixhide)-min(ix))/k)
								if (slope>5.) min(ix) = iy
								call isegs(ixvis,iyvis,ix,min(ix))
								call mask(ixvis,iyvis,ix,min(ix),FALSE)
								break
								}
							}
						}
					}
				}
			ixsave = jrow(i,1)
			iysave = jrow(i,2)
			jrow(i,1) = ix1
			jrow(i,2) = iy1
			}
	if (vy<=(-ypos)) break	# dont need 2 iterations
	}
call isegf	# flush buffer
return
end
