SUPPORT(vislgs,		generate visible line - general slope)
subroutine vislgs(ix2,iy2)
INCLUDE(graphics)
common/bcptgs/ix1,iy1,lty
integer ix,iy,dx,dy
integer xmove,ymove
logical dotmod
if (ix2==ix1)	# vertical
	call visvgs(iy2)
else if (iy2==iy1)	# horizontal
	call vishgs(ix2)
else {
	QUERY( lty(lstyle) )
	lstyle = min0(11,max0(1,lstyle))
	dx = ix2-ix1
	dy = iy2-iy1
	lty = 3	# set lty based on slope
	if (dx*dy<0)
		lty = 4
	xmove = 4
	if (dx<=0)
		xmove = 2
	ymove = 3
	if (dy<=0)
		ymove = 1
	isw = 0	# choose which case to process
	if (iabs(dx)>iabs(dy))
		isw = isw+1
	if (isw*dx+(1-isw)*dy>0)
		isw = isw+2
	isw = isw+1
	switch(isw) {
		case 1:	# case 1 - neg. dy, dy drives
			s = -float(dx)/float(dy)
			xx = ix1
			leng = iy1-iy2
			if (leng!=0)
				do ii = 1,leng {
					if (dotmod(lstyle))
						call zputcz(5)
					call zputcz(ymove)
					iy1 = iy1-1
					xx = xx+s
					ix = xx
					if (ix!=ix1) {	# move on slower axis
						call zputcz(xmove)
						ix1 = ix
						}
					}
			if (dotmod(lstyle))
				call zputcz(5)
		case 2:	# case 2 - negative dx, dx drives
			s = -float(dy)/float(dx)
			yy = iy1
			leng = ix1-ix2
			if (leng!=0)
				do ii = 1,leng {
					if (dotmod(lstyle))
						call zputcz(5)
					call zputcz(xmove)
					ix1 = ix1-1
					yy = yy+s
					iy = yy
					if (iy!=iy1) {	# move on slower axis
						call zputcz(ymove)
						iy1 = iy
						}
					}
			if (dotmod(lstyle))
				call zputcz(5)
		case 3:	# case 3 positive dy, dy drives
			s = float(dx)/float(dy)
			xx = ix1
			leng = iy2-iy1
			if (leng!=0)
				do ii = 1,leng {
					if (dotmod(lstyle))
						call zputcz(5)
					call zputcz(ymove)
					iy1 = iy1+1
					xx = xx+s
					ix = xx
					if (ix!=ix1) {	# move on slower axis
						call zputcz(xmove)
						ix1 = ix
						}
					}
			if (dotmod(lstyle))
				call zputcz(5)
		case 4:	# case 4 - pos dx, dx drives
			s = float(dy)/float(dx)
			yy = iy1
			leng = ix2-ix1
			if (leng!=0)
				do ii = 1,leng {
					if (dotmod(lstyle))
						call zputcz(5)
					call zputcz(xmove)
					ix1 = ix1+1
					yy = yy+s
					iy = yy
					if (iy!=iy1) {	# move on slower axis
						call zputcz(ymove)
						iy1 = iy
						}
					}
			if (dotmod(lstyle))
				call zputcz(5)
		}
	}
return
end
