SUPPORT(zcnctz,		form chains of segments)
subroutine zcnctz(z,x,y,n,cex)
INCLUDE(graphics)
real x(n),y(n)
INCLUDE(stack)
# set some boundary values
QUERY( usr(xmin,xmax,ymin,ymax), uin(ux,uy), rsz(rx,ry) )
dx = .1*rx/ux
dy = .1*ry/uy	# use .1 of raster size as zero tolerance
xout = 2.*xmin-xmax
nn = 2*n+4
jxc = jstkgt(nn,REAL)	# allocate space for chains
# begin search
n1 = n-1
# n points to the next available position for a segment
do i = 1,n1,2	# find a segment not on a previous chain
	if (x(i)>=xmin) {
		ix0 = jxc+n/2
		iy0 = jxc+n+n/2+1
		ixn = ix0+1
		iyn = iy0+1
		rs(ix0) = x(i)
		rs(iy0) = y(i)
		rs(ixn) = x(i+1)
		rs(iyn) = y(i+1)
		ip2 = i+2
		if (ip2<=n1)
			repeat {
				do j = ip2,n1,2
					if (x(j)>=xmin) {
# try to insert new top or bottom--if successful,
# go to i+2 and start again
# segments put on chain are deleted by setting x to xout
						j1 = j+1
						if (abs(x(j)-rs(ix0))<=dx&&abs(y(j)-rs(iy0))<=dy) {
							ix0 = ix0-1
							iy0 = iy0-1
							rs(ix0) = x(j1)
							rs(iy0) = y(j1)
							x(j) = xout
							next 2
							}
						else if (abs(x(j)-rs(ixn))<=dx&&abs(y(j)-rs(iyn))<=dy) {
							ixn = ixn+1
							iyn = iyn+1
							rs(ixn) = x(j1)
							rs(iyn) = y(j1)
							x(j) = xout
							next 2
							}
						else if (abs(x(j1)-rs(ixn))<=dx&&abs(y(j1)-rs(iyn))<=dy) {
							ixn = ixn+1
							iyn = iyn+1
							rs(ixn) = x(j)
							rs(iyn) = y(j)
							x(j) = xout
							next 2
							}
						else if (abs(x(j1)-rs(ix0))<=dx&&abs(y(j1)-rs(iy0))<=dy) {
							ix0 = ix0-1
							iy0 = iy0-1
							rs(ix0) = x(j)
							rs(iy0) = y(j)
							x(j) = xout
							next 2
							}
						}
				break 1
				}
		call linesz(rs(ix0),rs(iy0),ixn-ix0+1)
		if (cex>0.0) {
			xx = (rs(ix0)+rs(ix0+1))*.5
			yy = (rs(iy0)+rs(iy0+1))*.5
			call realz(xx,yy,z)
			}
		}
n = 1
call jstkrl(1)
return
end
