SUPPORT(zscalz,		perform scaling from current figure, plot and user coordinates)
subroutine zscalz
common/bgrp/am(200)
logical xpd
if (am(96)<0.0)
	ierr = -1
if (ierr<0)	# force printing of error messages in this routine
	am(96) = 0.0
fx = am(45)-am(44)
fy = am(47)-am(46)
if (fx<=0.0||fy<=0.0) {
	call zerrpz("zscalz",TSTRING(Invalid figure region -- scaling not done))
	call tracez(ERRORFC)
	}
else {
	px = am(41)-am(40)
	py = am(43)-am(42)
	if (px<=0.0||py<=0.0) {
		call zerrpz("zscalz",TSTRING(Invalid plotting region -- scaling not done))
		call tracez(ERRORFC)
		}
	else {
		dux = am(62)-am(61)
		duy = am(64)-am(63)
		if (dux<=0.0||duy<=0.0) {
			call zerrpz("zscalz",TSTRING(Invalid user co-ordinates -- scaling not done))
			call tracez(ERRORFC)
			}
		else {
			xpd = (am(65)>0.5)
			am(123) = am(98)*(am(45)-am(44))	# figure size
			am(124) = am(99)*(am(47)-am(46))
			am(55) = am(98)*fx*px	# plot size
			am(56) = am(99)*fy*py
			am(76) = am(55)/dux	# user co-ordinates in physical length
			am(77) = am(56)/duy
			drw = am(23)-am(22)	# 22-25 give the display in rasters
			drh = am(25)-am(24)
			am(37) = px*fx*drw/dux	# user to rasters linear transform
			am(36) = am(22)+(am(40)*fx+am(44))*drw-am(37)*am(61)
			am(39) = py*fy*drh/duy
			am(38) = am(24)+(am(42)*fy+am(46))*drh-am(39)*am(63)
			if (xpd) {	# expand on - define range of figure
				am(32) = am(22)+am(44)*drw
				am(33) = am(22)+am(45)*drw
				am(34) = am(24)+am(46)*drh
				am(35) = am(24)+am(47)*drh
				}
			else {	# not expand mode
				am(32) = am(61)*am(37)+am(36)
				am(33) = am(62)*am(37)+am(36)
				am(34) = am(63)*am(39)+am(38)
				am(35) = am(64)*am(39)+am(38)
				}
			am(17) = 3.0	# signal scaling done
			call zcsizz
			}
		}
	}
if (ierr<0)
	am(96) = -1.
return
end
