SUPPORT(zzfigz,		determine figure region)
subroutine zzfigz
INCLUDE(graphics)
CHARACTER(ich,1)
CHARACTER(msg2,50)
data msg2/"Computed figure of type   does not fit "/
QUERY( fty(ich) )
fw = am(98)*(am(91)-am(90))/am(83)	# figure size
fh = am(99)*(am(93)-am(92))/am(82)
if(ich=="s")	# square
	ar = 1.0
else if(ich=="i"){	# inches
	if (am(123)>fw+am(70)||am(124)>fh+am(71)) {	#  figure fits? - allow 1 raster of error
		call zerrpz("zzfigz",TSTRING(Figure specified in inches too large))
		call tracez(ERRORFC)
		}
	pw = amin1(am(123),fw)
	ph = amin1(am(124),fh)
	}
else if(ich=="d"){	# direct
	fw = am(91)-am(90)
	fh = am(93)-am(92)
	pw1 = am(44)*fw+am(90)
	pw2 = am(45)*fw+am(90)
	ph1 = am(46)*fh+am(92)
	ph2 = am(47)*fh+am(92)
	}
if(ich=="a")	# aspect ratio
	ar = am(123)/am(124)
else{	# max "m" "c" "r"
	pw = fw
	ph = fh
	}
if(ich=="s" | ich=="a") {
	if (fw>ar*fh) {	# squeeze horizontally
		ph = fh
		pw = ph*ar
		}
	else {	# squeeze vertically
		pw = fw
		ph = pw/ar
		}
	}
if(ich!="d"){
	wextra = 0.5*(fw-pw)	# compute centered co-ordinates
	hextra = 0.5*(fh-ph)
	pw1 = amax1(0.0,am(90)+((am(81)-1.0)*fw+wextra)/am(98))
	pw2 = amin1(1.0,pw1+pw/am(98))
	ph1 = amax1(0.0,am(92)+((am(82)-am(80))*fh+hextra)/am(99))
	ph2 = amin1(1.,ph1+ph/am(99))
	}
if (pw1>=pw2||ph1>=ph2) {
	call jputch(msg2,39,EOS)
	call jputch(msg2,25,ich)
	call zerrpz("zzfigz",msg2)
	call tracez(ERRORFC)
	pw1 = 0.
	pw2 = 1.
	ph1 = 0.
	ph2 = 1.
	}
am(44) = pw1
am(45) = pw2
am(46) = ph1
am(47) = ph2
mode = am(69)+.5
if (mode!=0)
	call zzcsmz(mode)
call zzpltz
SPECIFY( new(TRUE) )
return
end
