SUPPORT(zzpltz,		determine plotting region)
subroutine zzpltz
INCLUDE(graphics)
CHARACTER(ich,1)
CHARACTER(msg2,50)
data msg2/"Computed plot of type   does not fit "/
QUERY( pty(ich) )
fwc = am(98)*(am(45)-am(44))	# figure size
fhc = am(99)*(am(47)-am(46))
w1 = am(51)	# margin size
w2 = am(53)
h1 = am(50)
h2 = am(52)
fw = fwc-w1-w2	# available figure space inside margins
fh = fhc-h1-h2	# compute figure size w/o margins
if(ich== "s")	# square
	ar = 1.0
else if(ich== "i"){	# inches
	if (am(55)>fw+am(70)||am(56)>fh+am(71)) {	# plot fits? - allow 1 raster of error
		call zerrpz("zzpltz",TSTRING(Plot specified in inches too large))
		call tracez(ERRORFC)
		}
	pw = amin1(am(55),fw)
	ph = amin1(am(56),fh)
	}
else if(ich== "d"){	# direct
	pw1 = am(40)
	pw2 = am(41)
	ph1 = am(42)
	ph2 = am(43)
	}
else if(ich== "a")	# aspect ratio
	ar = am(55)/am(56)
else{	# max "m"
	pw = fw
	ph = fh
	}
if(ich=="s" | ich=="a"){
	if (fw>ar*fh) {	# squeeze horizontally
		ph = fh
		pw = ph*ar
		}
	else {	# squeeze vertically
		pw = fw
		ph = pw/ar
		}
	}
# compute centered co-ordinates
if(ich!="d"){
	wextra = 0.5*(fw-pw)
	hextra = 0.5*(fh-ph)
	pw1 = amax1(0.0,(w1+wextra)/fwc)
	pw2 = amin1(1.0,(fwc-w2-wextra)/fwc)
	ph1 = amax1(0.0,(h1+hextra)/fhc)
	ph2 = amin1(1.,(fhc-h2-hextra)/fhc)
	}
if (pw1>=pw2||ph1>=ph2) {
	call jputch(msg2,37,EOS)
	call jputch(msg2,23,ich)
	call zerrpz("zzpltz",msg2)
	call tracez(ERRORFC)
	pw1 = 0.
	pw2 = 1.
	ph1 = 0.
	ph2 = 1.
	}
am(40) = pw1
am(41) = pw2
am(42) = ph1
am(43) = ph2
call zscalz
return
end
