SUPPORT(coeves,		coerce to vector structure)
subroutine coeves(parg,pout,dmode,naok)
POINTER parg,pout; integer dmode; logical naok
# parg: pointer to structure which (when dereferenced) must be vector
#	  or vector structure.
# pout: returned as pointer to vector or DATA component
# dmode: desired mode for data, or ANY
# naok: are missing values allowed
#
# this routine assumes that reals, integers and logicals obey the F77
# requirement of equal size & that NAs are coded identically for all modes
INCLUDE(struct, stack, print)

POINTER pi,deref,dirfnd,gtmode
integer i,length,chmode,modep

pout=deref(parg)
if(MODE(pout)==STR) pout=dirfnd(VALUE(pout),TSTRING(Data))
if(pout==NULL || MODE(pout)==NULL)  FATAL(Non-numeric vector) 
if(MODE(pout)>CHAR) FATAL(Invalid vector mode)

modep=MODE(pout)
if(dmode==ANY & naok) return

if(dmode==ANY) chmode=0
else if(dmode==modep)chmode=0
else chmode=10*modep+dmode  # digits are "from mode", "to mode"

if(dmode!=ANY) MODE(pout)=dmode

switch(chmode) {
	case 0,21,23,12,13,32,31:	# nothing - valid coerces
	default: ABORT("Cannot change ",C(TEXT(gtmode(modep)))," to ",C(TEXT(gtmode(dmode))))
	}

pi=VALUE(pout); length=LENGTH(pout)
for(i=0; i<length; i=i+1) {
	if( NAVALUE(pi,modep)){
		if(!naok) FATAL(Missing values not allowed)
		}
	else switch(chmode) {	# most likely mentioned first for speed
		case 23: rs(pi)=is(pi)
		case 32: is(pi)=rs(pi)
		case 12: if(ls(pi))is(pi)=1;  else is(pi)=0
		case 13: if(ls(pi))rs(pi)=1.; else rs(pi)=0.
		case 21: ls(pi)= is(pi)!=0
		case 31: ls(pi)= rs(pi)!=0.
		}
	pi=pi+1
	}
return
end
