ROUTINE(adjust,		proportional adjustment of table)
#     algorithm as 51.2 appl. statist. (1972), vol 21, no 2
subroutine adjust(nvar,x,y,z,locx,locy,locz,nx,ny,nz,dim,config,d)
define(`MAXVAR',15)
integer size(incr(MAXVAR)),dim(nvar),config(nvar),coord(MAXVAR)
real x(nx),y(ny),z(nz)
size(1) = 1	# set size array
for(k=1; k<=nvar; k=k+1){
	l = config(k)
	if (l==0) break
	size(k+1) = size(k)*dim(l)
	}
n = k-1	# number of variables in configuration
l = size(k)
j = locy
k = locz
do i = 1,l {
	e = abs(z(k)-y(j))
	if (e>d) d = e	# test size of deviation
	j = j+1
	k = k+1
	}
do k = 1,nvar	# initialize coordinates
	coord(k) = 0
i = locx
repeat {	# perform adjustment
	j = 0
	do k = 1,n {
		l = config(k)
		j = j+coord(l)*size(k)
		}
	k = j+locz
	j = j+locy
	if (y(j)<=0.0) x(i) = 0.	# note that y(j) should be non-negative
	else x(i) = x(i)*z(k)/y(j)
	i = i+1
	do k = 1,nvar {	# update coordinates
		coord(k) = coord(k)+1
		if (coord(k)<dim(k)) next 2
		coord(k) = 0
		}
	break
	}
return
end
